/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.kuali.common.util.equality.Equatable;

public class ObjectUtils {
    public static boolean equalByToString(Object reference, Object other) {
        Preconditions.checkNotNull((Object)reference);
        if (reference == other) {
            return true;
        }
        if (ObjectUtils.notEqual(reference, other)) {
            return false;
        }
        return reference.toString().equals(other.toString());
    }

    public static <T extends Comparable<? super T>> boolean equalByComparison(T reference, Object object) {
        if (ObjectUtils.notEqual(reference, object)) {
            return false;
        }
        Comparable other = (Comparable)object;
        return reference.compareTo((Comparable)other) == 0;
    }

    public static boolean notEqual(Object reference, Object other) {
        Preconditions.checkNotNull((Object)reference);
        if (other == null) {
            return true;
        }
        return !reference.getClass().equals(other.getClass());
    }

    public static <T extends Equatable> boolean equal(T reference, Object other) {
        Preconditions.checkNotNull(reference);
        if (reference == other) {
            return true;
        }
        if (ObjectUtils.notEqual(reference, other)) {
            return false;
        }
        return ObjectUtils.equal(reference, (Equatable)other);
    }

    private static boolean equal(Equatable reference, Equatable other) {
        Object[] values2;
        Object[] values1 = reference.getEqualityValues();
        Preconditions.checkState((values1.length == (values2 = other.getEqualityValues()).length ? 1 : 0) != 0, (String)"value arrays must be the same. values1.length=%s values2.length=%s", (Object[])new Object[]{values1.length, values2.length});
        for (int i = 0; i < values1.length; ++i) {
            if (Objects.equals(values1[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean equalsByToString(Object reference, Object other) {
        return ObjectUtils.equalByToString(reference, other);
    }
}

