/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.kuali.common.util.base.Exceptions;

public class Callables {
    public static <T> List<T> submitCallables(List<? extends Callable<T>> callables) {
        Preconditions.checkNotNull(callables);
        if (callables.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService pool = Executors.newFixedThreadPool(callables.size());
        ArrayList futures = Lists.newArrayList();
        for (Callable<T> callable : callables) {
            futures.add(pool.submit(callable));
        }
        ArrayList elements = Lists.newArrayList();
        for (Future future : futures) {
            elements.add(Callables.get(future));
        }
        return elements;
    }

    protected static <T> T get(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw Exceptions.illegalState(e);
        }
        catch (ExecutionException e) {
            throw Exceptions.illegalState(e);
        }
    }
}

