/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base.string;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.common.util.base.Precondition;

public final class SplitterFunction
implements Function<Set<String>, Set<String>> {
    private final Splitter splitter;
    private final String separator;

    public SplitterFunction() {
        this(".");
    }

    public SplitterFunction(String separator) {
        this.separator = Precondition.checkNotNull(separator, "separator");
        this.splitter = Splitter.on((String)separator);
    }

    public Set<String> apply(Set<String> strings) {
        Precondition.checkNotNull(strings, "strings");
        HashSet set = Sets.newHashSet();
        for (String string : strings) {
            set.addAll(this.apply(string));
        }
        return ImmutableSet.copyOf((Collection)set);
    }

    protected Set<String> apply(String string) {
        Precondition.checkNotNull(string, "string");
        List tokens = this.splitter.splitToList((CharSequence)string);
        HashSet strings = Sets.newHashSet();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            sb = i != 0 ? sb.append(this.separator) : sb;
            String token = Precondition.checkNotBlank((String)tokens.get(i), "token");
            String element = sb.append(token).toString();
            Preconditions.checkArgument((boolean)strings.add(element), (String)"%s is a duplicate token -> [%s]", (Object[])new Object[]{element, string});
        }
        return strings;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Splitter getSplitter() {
        return this.splitter;
    }
}

