/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.condition;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.kuali.common.util.condition.Condition;

public final class BeforeCondition
implements Condition {
    private final long millis;

    public BeforeCondition(Date date) {
        this(date.getTime());
    }

    public BeforeCondition(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"'millis' must be >= 0");
        this.millis = millis;
    }

    @Override
    public boolean isTrue() {
        return System.currentTimeMillis() < this.millis;
    }

    public long getMillis() {
        return this.millis;
    }

    public Date getDate() {
        return new Date(this.millis);
    }
}

