/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.jasypt;

import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.EncryptionStrength;

public class Jasypt {
    public static TextEncryptor buildTextEncryptor(EncryptionContext context) {
        return Jasypt.buildTextEncryptor(context.getPassword(), context.getStrength());
    }

    public static TextEncryptor buildTextEncryptor(String password, EncryptionStrength strength) {
        Precondition.checkNotBlank(password, "password");
        Precondition.checkNotNull(strength, "strength");
        switch (strength) {
            case BASIC_ENCRYPTION_STRENGTH: {
                BasicTextEncryptor basic = new BasicTextEncryptor();
                basic.setPassword(password);
                return basic;
            }
            case STRONG_ENCRYPTION_STRENGTH: {
                StrongTextEncryptor strong = new StrongTextEncryptor();
                strong.setPassword(password);
                return strong;
            }
        }
        throw Exceptions.illegalArgument("encryption strength [%s] is unknown", new Object[]{strength});
    }
}

