/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.openssl;

import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.EncryptionStrength;

public final class OpenSSLContext {
    private final int iterations;
    private final String saltPrefix;
    private final int saltSize;
    private final int keySizeBits;
    private final String transformation;
    private final String digestAlgorithm;
    private final String algorithm;

    private OpenSSLContext(Builder builder) {
        this.iterations = builder.iterations;
        this.saltSize = builder.saltSize;
        this.saltPrefix = builder.saltPrefix;
        this.keySizeBits = builder.keySizeBits;
        this.transformation = builder.transformation;
        this.digestAlgorithm = builder.digestAlgorithm;
        this.algorithm = builder.algorithm;
    }

    public static OpenSSLContext buildOpenSSLContext(EncryptionStrength strength) {
        if (EncryptionStrength.STRONG_ENCRYPTION_STRENGTH.equals((Object)strength)) {
            return OpenSSLContext.builder().withKeySizeBits(256).build();
        }
        return OpenSSLContext.buildDefaultOpenSSLContext();
    }

    public static OpenSSLContext buildDefaultOpenSSLContext() {
        return OpenSSLContext.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getSaltSize() {
        return this.saltSize;
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSaltPrefix() {
        return this.saltPrefix;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<OpenSSLContext> {
        private static final int STRONG_KEY_SIZE_BITS = 256;
        private int iterations = 1;
        private String saltPrefix = "Salted__";
        private int saltSize = 8;
        private int keySizeBits = 128;
        private String transformation = "AES/CBC/PKCS5Padding";
        private String digestAlgorithm = "MD5";
        private String algorithm = "AES";

        private static OpenSSLContext validate(OpenSSLContext instance) {
            Precondition.checkMin(instance.iterations, 0, "iterations");
            Precondition.checkNotBlank(instance.saltPrefix, "saltPrefix");
            Precondition.checkMin(instance.saltSize, 0, "saltSize");
            Precondition.checkMin(instance.keySizeBits, 0, "keySizeBits");
            Precondition.checkNotBlank(instance.transformation, "transformation");
            Precondition.checkNotBlank(instance.digestAlgorithm, "digest");
            Precondition.checkNotBlank(instance.algorithm, "algorithm");
            return instance;
        }

        public OpenSSLContext build() {
            return Builder.validate(new OpenSSLContext(this));
        }

        public Builder withAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder withSaltPrefix(String saltPrefix) {
            this.saltPrefix = saltPrefix;
            return this;
        }

        public Builder withDigestAlgorithm(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        public Builder withTransformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        public Builder withIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder withSaltSize(int saltSize) {
            this.saltSize = saltSize;
            return this;
        }

        public Builder withKeySizeBits(int keySizeBits) {
            this.keySizeBits = keySizeBits;
            return this;
        }

        public int getIterations() {
            return this.iterations;
        }

        public void setIterations(int iterations) {
            this.iterations = iterations;
        }

        public String getSaltPrefix() {
            return this.saltPrefix;
        }

        public void setSaltPrefix(String saltPrefix) {
            this.saltPrefix = saltPrefix;
        }

        public int getSaltSize() {
            return this.saltSize;
        }

        public void setSaltSize(int saltSize) {
            this.saltSize = saltSize;
        }

        public int getKeySizeBits() {
            return this.keySizeBits;
        }

        public void setKeySizeBits(int keySizeBits) {
            this.keySizeBits = keySizeBits;
        }

        public String getTransformation() {
            return this.transformation;
        }

        public void setTransformation(String transformation) {
            this.transformation = transformation;
        }

        public String getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public void setDigestAlgorithm(String digest) {
            this.digestAlgorithm = digest;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

