/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.provider;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.EncryptionStrength;
import org.kuali.common.util.encrypt.provider.DefaultEncryptionContextProviderChain;
import org.kuali.common.util.encrypt.provider.EncryptionContextProvider;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.Loggers;
import org.slf4j.Logger;

public final class FileEncryptionContextProvider
implements EncryptionContextProvider {
    private static final Logger logger = Loggers.newLogger();
    private static final String ENC_PASSWORD_FILE_SYS_KEY = "enc.password.file";
    private static final String ENC_PASSWORD_FILE_ENV_KEY = DefaultEncryptionContextProviderChain.toEnvKey("enc.password.file");
    private static final File DEFAULT_ENC_PASSWORD_FILE = new CanonicalFile(System.getProperty("user.home") + "/.enc/password");

    @Override
    public Optional<EncryptionContext> getEncryptionContext() {
        File file = FileEncryptionContextProvider.getEncPasswordFile();
        if (!file.exists()) {
            logger.debug(String.format("[%s] does not exist", file));
            return Optional.absent();
        }
        List<String> lines = FileEncryptionContextProvider.readLines(file);
        String password = this.getPassword(lines);
        EncryptionStrength strength = this.getStrength(lines);
        logger.debug(String.format("[%s, %s] encryption password located", new Object[]{file, strength}));
        return Optional.of((Object)new EncryptionContext(password, strength));
    }

    protected EncryptionStrength getStrength(List<String> lines) {
        if (lines.size() < 2) {
            return EncryptionStrength.DEFAULT_ENCRYPTION_STRENGTH;
        }
        String value = lines.get(1);
        if (StringUtils.isBlank((CharSequence)value)) {
            return EncryptionStrength.DEFAULT_ENCRYPTION_STRENGTH;
        }
        return EncryptionStrength.valueOf(value.toUpperCase().trim());
    }

    protected String getPassword(List<String> lines) {
        Preconditions.checkState((lines.size() > 0 ? 1 : 0) != 0, (Object)"[%s] must contain at least one line");
        String password = StringUtils.trimToNull((String)lines.get(0));
        Precondition.checkNotBlank(password, "password");
        return password;
    }

    protected static List<String> readLines(File file) {
        try {
            return ImmutableList.copyOf((Collection)FileUtils.readLines((File)file));
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
    }

    protected static File getEncPasswordFile() {
        Optional<String> sys = FileEncryptionContextProvider.getOptional(System.getProperty(ENC_PASSWORD_FILE_SYS_KEY));
        if (sys.isPresent()) {
            CanonicalFile file = new CanonicalFile((String)sys.get());
            logger.debug(String.format("encryption system property: %s=[%s]", ENC_PASSWORD_FILE_SYS_KEY, file.getPath()));
            return file;
        }
        Optional<String> env = FileEncryptionContextProvider.getOptional(System.getenv(ENC_PASSWORD_FILE_ENV_KEY));
        if (env.isPresent()) {
            CanonicalFile file = new CanonicalFile((String)env.get());
            logger.debug(String.format("encryption environment variable: %s=[%s]", ENC_PASSWORD_FILE_ENV_KEY, file.getPath()));
            return file;
        }
        return DEFAULT_ENC_PASSWORD_FILE;
    }

    protected static Optional<String> getOptional(String value) {
        return Optional.fromNullable((Object)StringUtils.trimToNull((String)value));
    }
}

