/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Version;
import org.kuali.common.util.VersionUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SetSourceDbSchemaNameExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(SetSourceDbSchemaNameExecutable.class);
    String sourceDbSchemaNameKey = "jdbc.source.db.username";
    String dbBranchQualifierKey = "db.branch.qualifier";
    String baseSourceDbSchemaName;
    Properties mavenProperties;
    String version;
    boolean skip;

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution");
            return;
        }
        Assert.notNull((Object)this.mavenProperties, (String)"mavenProperties is null");
        Assert.hasText((String)this.baseSourceDbSchemaName, (String)"baseSourceDbSchemaName is blank");
        String existingValue = this.mavenProperties.getProperty(this.sourceDbSchemaNameKey);
        if (!StringUtils.isBlank((CharSequence)existingValue)) {
            logger.info("Existing value - [{}={}]", (Object)this.sourceDbSchemaNameKey, (Object)existingValue);
            return;
        }
        String qualifier = this.getQualifier(this.mavenProperties, this.dbBranchQualifierKey, this.version);
        String sourceDbSchemaName = this.baseSourceDbSchemaName + qualifier;
        this.mavenProperties.setProperty(this.sourceDbSchemaNameKey, sourceDbSchemaName);
        logger.debug("Set property - [{}={}]", (Object)this.sourceDbSchemaNameKey, (Object)sourceDbSchemaName);
    }

    protected String getQualifier(Properties mavenProperties, String explicitQualifierKey, String version) {
        String qualifier = mavenProperties.getProperty(explicitQualifierKey);
        if (!StringUtils.isBlank((CharSequence)qualifier)) {
            return "_" + qualifier;
        }
        Version v = VersionUtils.getVersion(version);
        if (StringUtils.isBlank((CharSequence)v.getQualifier())) {
            return qualifier;
        }
        qualifier = v.getQualifier();
        qualifier = StringUtils.upperCase((String)qualifier);
        qualifier = StringUtils.replace((String)qualifier, (String)"-", (String)"_");
        qualifier = StringUtils.replace((String)qualifier, (String)".", (String)"_");
        qualifier = "_" + qualifier;
        return qualifier;
    }

    public Properties getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Properties mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getBaseSourceDbSchemaName() {
        return this.baseSourceDbSchemaName;
    }

    public void setBaseSourceDbSchemaName(String sourceDbSchemaName) {
        this.baseSourceDbSchemaName = sourceDbSchemaName;
    }

    public String getSourceDbSchemaNameKey() {
        return this.sourceDbSchemaNameKey;
    }

    public void setSourceDbSchemaNameKey(String sourceDbSchemaNameKey) {
        this.sourceDbSchemaNameKey = sourceDbSchemaNameKey;
    }

    public String getDbBranchQualifierKey() {
        return this.dbBranchQualifierKey;
    }

    public void setDbBranchQualifierKey(String dbBranchQualifierKey) {
        this.dbBranchQualifierKey = dbBranchQualifierKey;
    }
}

