/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.base.Threads;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.impl.ExecutablesRunner;
import org.kuali.common.util.log.Loggers;
import org.slf4j.Logger;

public final class ConcurrentExecutables
implements Executable,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = Loggers.newLogger();
    private final ImmutableList<Executable> executables;
    private final boolean skip;
    private final boolean timed;
    private final Optional<Integer> maxThreads;
    private Optional<IllegalStateException> uncaughtException = Optional.absent();

    public static void execute(Executable ... executables) {
        ConcurrentExecutables.create(executables).execute();
    }

    public static void execute(List<Executable> executables) {
        ConcurrentExecutables.create(executables).execute();
    }

    public static void executeConcurrently(List<Executable> executables, int maxThreads) {
        ConcurrentExecutables.builder(executables).withMaxThreads(maxThreads).build().execute();
    }

    public static ConcurrentExecutables create(Executable ... executables) {
        return ConcurrentExecutables.builder(executables).build();
    }

    public static ConcurrentExecutables create(List<Executable> executables) {
        return ConcurrentExecutables.builder(executables).build();
    }

    public static Builder builder(Executable ... executables) {
        return new Builder(executables);
    }

    public static Builder builder(List<Executable> executables) {
        return new Builder(executables);
    }

    private ConcurrentExecutables(Builder builder) {
        this.executables = ImmutableList.copyOf((Collection)builder.executables);
        this.skip = builder.skip;
        this.timed = builder.timed;
        this.maxThreads = builder.maxThreads;
    }

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution of {} executables", (Object)this.executables.size());
            return;
        }
        List<Thread> threads = this.getThreads((List<Executable>)this.executables, this.maxThreads);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Threads.start(threads);
        Threads.join(threads);
        if (this.uncaughtException.isPresent()) {
            throw (IllegalStateException)this.uncaughtException.get();
        }
        if (this.timed) {
            logger.info("------------------------------------------------------------------------");
            logger.info("Total Time: {} (Wall Clock)", (Object)FormatUtils.getTime(stopwatch));
            logger.info("------------------------------------------------------------------------");
        }
    }

    protected List<Thread> getThreads(List<Executable> executables, Optional<Integer> maxThreads) {
        int max = maxThreads.isPresent() ? ((Integer)maxThreads.get()).intValue() : executables.size();
        int size = (int)Math.max(Math.ceil((double)executables.size() / ((double)max * 1.0)), 1.0);
        List partitions = Lists.partition(executables, (int)size);
        ArrayList threads = Lists.newArrayList();
        for (List partition : partitions) {
            ExecutablesRunner runnable = new ExecutablesRunner(partition);
            Thread thread = new Thread((Runnable)runnable, "Executable");
            thread.setUncaughtExceptionHandler(this);
            threads.add(thread);
        }
        return threads;
    }

    @Override
    public synchronized void uncaughtException(Thread thread, Throwable uncaughtException) {
        if (!this.uncaughtException.isPresent()) {
            String context = "Exception in thread [" + thread.getId() + ":" + thread.getName() + "]";
            this.uncaughtException = Optional.of((Object)new IllegalStateException(context, uncaughtException));
        }
    }

    public ImmutableList<Executable> getExecutables() {
        return this.executables;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isTimed() {
        return this.timed;
    }

    public Optional<IllegalStateException> getUncaughtException() {
        return this.uncaughtException;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<ConcurrentExecutables> {
        private final List<Executable> executables;
        private boolean skip = false;
        private boolean timed = false;
        private Optional<Integer> maxThreads = Optional.absent();

        public Builder(Executable ... executables) {
            this((List<Executable>)ImmutableList.copyOf((Object[])executables));
        }

        public Builder(List<Executable> executables) {
            this.executables = ImmutableList.copyOf(executables);
        }

        public Builder timed(boolean timed) {
            this.timed = timed;
            return this;
        }

        public Builder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        public Builder withMaxThreads(int maxThreads) {
            this.maxThreads = Optional.of((Object)maxThreads);
            return this;
        }

        public ConcurrentExecutables build() {
            ConcurrentExecutables instance = new ConcurrentExecutables(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(ConcurrentExecutables instance) {
            Precondition.checkNotNull(instance.executables, "executables");
            Precondition.checkNotNull(instance.uncaughtException, "uncaughtException");
        }
    }
}

