/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;

public final class CanonicalFile
extends File {
    private static final long serialVersionUID = -8366640724070158688L;

    public CanonicalFile(File parent, String child) {
        this(new File(parent, child));
    }

    public CanonicalFile(String parent, String child) {
        this(new File(parent, child));
    }

    public CanonicalFile(URI uri) {
        this(new File(uri));
    }

    public CanonicalFile(String path) {
        this(new File(path));
    }

    public CanonicalFile(File file) {
        super(CanonicalFile.getCanonicalPath(file));
    }

    public static final CanonicalFile cwd() {
        return new CanonicalFile(".");
    }

    protected static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("unexpected io error", e);
        }
    }
}

