/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log;

import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.ListUtils;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public class LogTableContext {
    public static final LoggerLevel DEFAULT_LOGGER_LEVEL = LoggerLevel.INFO;
    public static final boolean DEFAULT_LEFT_ALIGN = false;
    public static final Logger DEFAULT_LOGGER = LoggerUtils.LOGGER_UTILS_LOGGER;
    public static final String NO_TITLE = "NONE";
    public static final String DEFAULT_TITLE = "NONE";
    private final String title;
    private final List<String> columns;
    private final List<Object[]> rows;
    private final Logger logger;
    private final LoggerLevel level;
    private final boolean leftAlign;

    public LogTableContext(List<String> columns, List<Object[]> rows) {
        this(columns, rows, DEFAULT_LOGGER);
    }

    public LogTableContext(String title, List<String> columns, List<Object[]> rows) {
        this(title, columns, rows, DEFAULT_LOGGER_LEVEL, DEFAULT_LOGGER, false);
    }

    public LogTableContext(List<String> columns, List<Object[]> rows, Logger logger) {
        this("NONE", columns, rows, logger);
    }

    public LogTableContext(String title, List<String> columns, List<Object[]> rows, Logger logger) {
        this(title, columns, rows, DEFAULT_LOGGER_LEVEL, logger, false);
    }

    public LogTableContext(List<String> columns, List<Object[]> rows, LoggerLevel level, Logger logger, boolean leftAlign) {
        this("NONE", columns, rows, level, logger, leftAlign);
    }

    public LogTableContext(String title, List<String> columns, List<Object[]> rows, LoggerLevel level, Logger logger, boolean leftAlign) {
        Assert.noNulls(new Object[]{columns, rows, logger, level});
        Assert.noBlanks(title);
        this.title = title;
        this.columns = ListUtils.newImmutableArrayList(columns);
        this.rows = ListUtils.newImmutableArrayList(rows);
        this.level = level;
        this.logger = logger;
        this.leftAlign = leftAlign;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public boolean isLeftAlign() {
        return this.leftAlign;
    }
}

