/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log.log4j.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ListUtils;
import org.kuali.common.util.log.log4j.jaxb.DebugAdapter;
import org.kuali.common.util.log.log4j.jaxb.RepositoryThresholdAdapter;
import org.kuali.common.util.log.log4j.model.Appender;
import org.kuali.common.util.log.log4j.model.Debug;
import org.kuali.common.util.log.log4j.model.Logger;
import org.kuali.common.util.log.log4j.model.Threshold;
import org.kuali.common.util.xml.jaxb.adapter.OmitFalseAdapter;

@XmlRootElement(name="log4j:configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class Log4JConfiguration {
    @XmlAttribute(name="xmlns:log4j")
    private final String namespace;
    @XmlElement(name="appender")
    private final List<Appender> appenders;
    @XmlElement
    private final Logger root;
    @XmlElement(name="logger")
    private final List<Logger> loggers;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=OmitFalseAdapter.class)
    private final Boolean reset;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DebugAdapter.class)
    private final Debug debug;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=RepositoryThresholdAdapter.class)
    private final Threshold threshold;

    public List<Logger> getLoggers() {
        return Collections.unmodifiableList(this.loggers);
    }

    public List<Appender> getAppenders() {
        return Collections.unmodifiableList(this.appenders);
    }

    public boolean getReset() {
        return this.reset;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    public Logger getRoot() {
        return this.root;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private Log4JConfiguration() {
        this(new Builder(Logger.DEFAULT).finish());
    }

    private Log4JConfiguration(Builder builder) {
        this.root = builder.root;
        this.appenders = builder.appenders;
        this.loggers = builder.loggers;
        this.reset = builder.reset;
        this.debug = builder.debug;
        this.threshold = builder.threshold;
        this.namespace = builder.namespace;
    }

    public static class Builder {
        private final Logger root;
        private String namespace = "http://jakarta.apache.org/log4j/";
        private List<Appender> appenders = Appender.EMPTY;
        private List<Logger> loggers = Logger.EMPTY;
        private boolean reset = false;
        private Debug debug = Debug.DEFAULT_VALUE;
        private Threshold threshold = Threshold.DEFAULT_REPOSITORY_VALUE;

        public Builder(Logger root) {
            Assert.noNulls(root);
            this.root = root;
        }

        public Builder appenders(List<Appender> appenders) {
            this.appenders = appenders;
            return this;
        }

        public Builder appender(Appender appender) {
            this.appenders = CollectionUtils.singletonList(appender);
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder logger(Logger logger) {
            this.loggers = CollectionUtils.singletonList(logger);
            return this;
        }

        public Builder loggers(List<Logger> loggers) {
            this.loggers = loggers;
            return this;
        }

        public Builder reset(boolean reset) {
            this.reset = reset;
            return this;
        }

        public Builder debug(Debug debug) {
            this.debug = debug;
            return this;
        }

        public Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        private Builder finish() {
            Assert.noNulls(new Object[]{this.root, this.appenders, this.loggers, this.debug, this.threshold});
            Assert.isFalse(Logger.isThresholdNull(this.root), "root logging threshold is null");
            Assert.noBlanks(this.namespace);
            this.appenders = ListUtils.newArrayList(this.appenders);
            this.loggers = ListUtils.newArrayList(this.loggers);
            return this;
        }

        public Log4JConfiguration build() {
            this.finish();
            return new Log4JConfiguration(this);
        }
    }
}

