/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log.log4j.spring;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.PatternLayout;
import org.kuali.common.util.log.log4j.DefaultLog4JService;
import org.kuali.common.util.log.log4j.Log4JService;
import org.kuali.common.util.log.log4j.ParamFactory;
import org.kuali.common.util.log.log4j.model.Appender;
import org.kuali.common.util.log.log4j.model.AppenderRef;
import org.kuali.common.util.log.log4j.model.Layout;
import org.kuali.common.util.log.log4j.model.Level;
import org.kuali.common.util.log.log4j.model.Log4JConfiguration;
import org.kuali.common.util.log.log4j.model.Logger;
import org.kuali.common.util.log.log4j.model.Param;
import org.kuali.common.util.log.log4j.model.Threshold;
import org.kuali.common.util.xml.service.XmlService;
import org.kuali.common.util.xml.spring.Log4JXmlServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={Log4JXmlServiceConfig.class})
public class Log4JConfig {
    protected static final String SPRING = "org.springframework";
    protected static final String JAXB = "javax.xml.bind";
    protected static final String STDOUT = "stdout";
    @Autowired
    XmlService service;

    @Bean
    public Log4JService log4jService() {
        return new DefaultLog4JService(this.service);
    }

    @Bean
    public Log4JConfiguration log4JContextDefault() {
        return this.getLog4JContext("[%-4p] %C - %m%n", Threshold.INFO);
    }

    @Bean
    public Log4JConfiguration log4JContextJAXB() {
        return this.getLog4JContext("[%-4p] %C.%M - %m%n", Threshold.INFO);
    }

    @Bean
    public Log4JConfiguration log4JContextTest() {
        return this.getLog4JContext("[%-4p] %C.%M - %m%n", Threshold.INFO);
    }

    @Bean
    public Log4JConfiguration log4JContextDebug() {
        return this.getLog4JContext("[%-4p] %C.%M - %m%n", Threshold.DEBUG);
    }

    @Bean
    public Log4JConfiguration log4JContextMaven() {
        Logger spring = new Logger(SPRING, new Level(Threshold.WARN));
        return this.getLog4JContext("[%-4p] %m%n", Threshold.INFO, spring);
    }

    protected Log4JConfiguration getLog4JContext(String pattern, Threshold threshold) {
        return this.getLog4JContext(pattern, threshold, null);
    }

    protected Log4JConfiguration getLog4JContext(String pattern, Threshold threshold, Logger logger) {
        Param param = ParamFactory.getPatternParam(pattern);
        Layout layout = new Layout(PatternLayout.class, param);
        Appender console = new Appender(STDOUT, ConsoleAppender.class, layout);
        AppenderRef ref = new AppenderRef(console.getName());
        Logger root = Logger.getRootLogger(ref, new Level(threshold));
        if (logger == null) {
            return new Log4JConfiguration.Builder(root).appender(console).reset(true).build();
        }
        return new Log4JConfiguration.Builder(root).appender(console).logger(logger).reset(true).build();
    }
}

