/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.maven.LocalRepositoryService;
import org.kuali.common.util.maven.RepositoryUtils;
import org.kuali.common.util.maven.model.Artifact;

public final class DefaultLocalRepositoryService
implements LocalRepositoryService {
    private final File localRepository;

    public DefaultLocalRepositoryService() {
        this(RepositoryUtils.getDefaultLocalRepository());
    }

    public DefaultLocalRepositoryService(File localRepository) {
        this.localRepository = new CanonicalFile(Precondition.checkNotNull(localRepository, "localRepository"));
    }

    @Override
    public List<File> getFiles(List<Artifact> artifacts) {
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact artifact : artifacts) {
            File file = this.getFile(artifact);
            files.add(file);
        }
        return files;
    }

    @Override
    public File getFile(Artifact artifact) {
        return RepositoryUtils.getFile(this.localRepository, artifact);
    }

    @Override
    public File getLocalRepository() {
        return this.localRepository;
    }
}

