/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven.model;

import com.google.common.base.Optional;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.nullify.NullUtils;

public final class Artifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Optional<String> classifier;
    private final String type;

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public static Builder builder(String groupId, String artifactId, String version) {
        return new Builder(groupId, artifactId, version);
    }

    private Artifact(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        this.classifier = builder.classifier;
        this.type = builder.type;
    }

    public static class Builder {
        public static final String DEFAULT_TYPE = "jar";
        private final String groupId;
        private final String artifactId;
        private final String version;
        private Optional<String> classifier = Optional.absent();
        private String type = "jar";

        public Builder(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public Builder classifier(String classifier) {
            return this.withClassifier((Optional<String>)Optional.fromNullable((Object)NullUtils.trimToNull(classifier)));
        }

        public Builder withClassifier(String classifier) {
            return this.withClassifier((Optional<String>)Optional.fromNullable((Object)NullUtils.trimToNull(classifier)));
        }

        public Builder withClassifier(Optional<String> classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder type(String type) {
            return this.withType(type);
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Artifact build() {
            return Builder.validate(new Artifact(this));
        }

        private static Artifact validate(Artifact instance) {
            Precondition.checkNotBlank(instance.groupId, "groupId");
            Precondition.checkNotBlank(instance.artifactId, "artifactId");
            Precondition.checkNotBlank(instance.type, "type");
            Precondition.checkNotBlank((Optional<String>)instance.classifier, "classifier");
            return instance;
        }
    }
}

