/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public final class MetaInfResource
implements Comparable<MetaInfResource> {
    public static final long UNKNOWN_SIZE = -1L;
    public static final long UNKNOWN_LINECOUNT = -1L;
    private final String location;
    private final long size;
    private final long lineCount;

    public MetaInfResource(String location) {
        this(location, -1L, -1L);
    }

    public MetaInfResource(String location, long size, long lineCount) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)location) ? 1 : 0) != 0, (Object)"'location' cannot be blank");
        Preconditions.checkArgument((size == -1L || size >= 0L ? 1 : 0) != 0, (String)"'size' must be >= zero. Use %s to indicate unknown", (Object[])new Object[]{-1L});
        Preconditions.checkArgument((lineCount == -1L || lineCount >= 0L ? 1 : 0) != 0, (String)"'lineCount' must be >= zero. Use %s to indicate unknown", (Object[])new Object[]{-1L});
        this.location = location;
        this.size = size;
        this.lineCount = lineCount;
    }

    @Override
    public int compareTo(MetaInfResource other) {
        return this.location.compareTo(other.getLocation());
    }

    public String getLocation() {
        return this.location;
    }

    public long getSize() {
        return this.size;
    }

    public long getLineCount() {
        return this.lineCount;
    }
}

