/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfConfigUtils;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfExecutableConfig;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutowiredProjectConfig.class, MetaInfExecutableConfig.class, SpringServiceConfig.class})
public class SqlConfig
implements MetaInfContextsConfig {
    private static final boolean DEFAULT_GENERATE_RELATIVE_PATHS = true;
    private static final String RELATIVE_KEY = "metainf.sql.relative";
    private static final String DB_VENDOR_KEY = "db.vendor";
    private static final String PREFIX = "sql";
    @Autowired
    EnvironmentService env;
    @Autowired
    Project project;
    @Autowired
    Build build;

    @Override
    @Bean
    public List<MetaInfContext> metaInfContexts() {
        Map<MetaInfGroup, String> defaultIncludes = this.getDefaultIncludes();
        ArrayList<MetaInfContext> contexts = new ArrayList<MetaInfContext>();
        for (MetaInfGroup group : MetaInfGroup.values()) {
            MetaInfContext context = this.getMetaInfContext(group, defaultIncludes);
            contexts.add(context);
        }
        return contexts;
    }

    protected MetaInfContext getMetaInfContext(MetaInfGroup group, Map<MetaInfGroup, String> defaultIncludes) {
        String databaseVendor = this.env.getString(DB_VENDOR_KEY);
        boolean relativePaths = this.env.getBoolean(RELATIVE_KEY, true);
        File outputFile = MetaInfUtils.getOutputFile(this.project, this.build, databaseVendor, group);
        String includesKey = MetaInfConfigUtils.getIncludesKey(group, PREFIX);
        String excludesKey = MetaInfConfigUtils.getExcludesKey(group, PREFIX);
        List<String> includes = SpringUtils.getNoneSensitiveListFromCSV(this.env, includesKey, defaultIncludes.get((Object)group));
        List<String> excludes = SpringUtils.getNoneSensitiveListFromCSV(this.env, excludesKey, "NONE");
        File scanDir = this.build.getOutputDir();
        String encoding = this.build.getEncoding();
        return new MetaInfContext.Builder(outputFile, encoding, scanDir).includes(includes).excludes(excludes).relativePaths(relativePaths).build();
    }

    protected Map<MetaInfGroup, String> getDefaultIncludes() {
        HashMap<MetaInfGroup, String> map = new HashMap<MetaInfGroup, String>();
        map.put(MetaInfGroup.SCHEMA, "**/initial-db/**/*create-schema.sql");
        map.put(MetaInfGroup.DATA, "**/initial-db/**/data/*.sql");
        map.put(MetaInfGroup.CONSTRAINTS, "**/initial-db/**/*constraints.sql");
        map.put(MetaInfGroup.OTHER, "**/upgrades/**/*.sql");
        return map;
    }
}

