/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project.model;

import java.util.Properties;
import org.kuali.common.util.ObjectUtils;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.property.ImmutableProperties;

public final class ImmutableProject
implements Project {
    private final ProjectIdentifier identifier;
    private final String version;
    private final ImmutableProperties properties;
    private final String id;
    private final int hashCode;

    public static ImmutableProject copyOf(Project project) {
        if (project instanceof ImmutableProject) {
            return (ImmutableProject)project;
        }
        return new ImmutableProject(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getProperties());
    }

    public ImmutableProject(ProjectIdentifier identifier, String version, Properties properties) {
        Precondition.checkNotNull(identifier, "identifier");
        Precondition.checkNotBlank(version, "version");
        Precondition.checkNotNull(properties, "properties");
        this.identifier = identifier;
        this.version = version;
        this.properties = ImmutableProperties.copyOf(properties);
        this.id = identifier.getIdentifier() + ":" + version;
        this.hashCode = identifier.hashCode();
    }

    public ImmutableProject(String groupId, String artifactId, String version, Properties properties) {
        this(new ProjectIdentifier(groupId, artifactId), version, properties);
    }

    @Override
    public String getGroupId() {
        return this.identifier.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.identifier.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public String getIdentifier() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return ObjectUtils.equalByToString(this, other);
    }
}

