/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project.spring;

import java.util.Properties;
import org.kuali.common.util.maven.MavenUtils;
import org.kuali.common.util.maven.spring.AutowiredMavenProperties;
import org.kuali.common.util.maven.spring.NoAutowiredMavenProperties;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.project.spring.ProjectConfig;
import org.kuali.common.util.project.spring.ProjectIdentifierConfig;
import org.kuali.common.util.project.spring.ProjectServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.Assert;

@Configuration
public class AutowiredProjectConfig {

    @Configuration
    @AutowiredMavenProperties
    static class AutowiredMavenPropertiesProjectConfig
    implements ProjectConfig {
        @Autowired
        @Qualifier(value="mavenProperties")
        Properties mavenProperties;

        AutowiredMavenPropertiesProjectConfig() {
        }

        @Override
        @Bean
        public Project project() {
            Assert.notNull((Object)this.mavenProperties, (String)"mavenProperties are null");
            MavenUtils.augmentProjectProperties(this.mavenProperties);
            return ProjectUtils.getProject(this.mavenProperties);
        }

        @Bean
        public Build build() {
            return ProjectUtils.getBuild(this.project());
        }
    }

    @Configuration
    @NoAutowiredMavenProperties
    @Import(value={ProjectServiceConfig.class})
    static class NoAutowiredMavenPropertiesProjectConfig
    implements ProjectConfig {
        @Autowired
        ProjectIdentifierConfig projectIdentifierConfig;
        @Autowired
        ProjectServiceConfig projectServiceConfig;

        NoAutowiredMavenPropertiesProjectConfig() {
        }

        @Override
        @Bean
        public Project project() {
            ProjectService service = this.projectServiceConfig.projectService();
            ProjectIdentifier identifier = this.projectIdentifierConfig.projectIdentifier();
            return service.getProject(identifier.getGroupId(), identifier.getArtifactId());
        }
    }
}

