/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.properties;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.FeatureIdentifier;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.project.model.ProjectResource;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesLocationService;

public class DefaultPropertiesLocationService
implements PropertiesLocationService {
    private static final boolean DEFAULT_CACHE_PROPERTIES_VALUE = true;
    private final ProjectService projectService;
    private final boolean cache;

    public DefaultPropertiesLocationService(ProjectService projectService) {
        this(projectService, true);
    }

    public DefaultPropertiesLocationService(ProjectService projectService, boolean cache) {
        Preconditions.checkNotNull((Object)projectService, (Object)"'projectService' cannot be null");
        this.projectService = projectService;
        this.cache = cache;
    }

    @Override
    public List<Location> getLocations(ProjectIdentifier identifier, List<String> filenames) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String filename : filenames) {
            locations.add(this.getLocation(identifier, filename));
        }
        return locations;
    }

    @Override
    public List<Location> getLocations(ProjectIdentifier identifier, String ... filenames) {
        return this.getLocations(identifier, Arrays.asList(filenames));
    }

    @Override
    public Location getLocation(ProjectIdentifier identifier, String filename) {
        Project project = this.projectService.getProject(identifier);
        String value = ProjectUtils.getClasspathPrefix(identifier) + "/" + filename;
        String encoding = ProjectUtils.getEncoding(project);
        return new Location(value, encoding, this.cache);
    }

    @Override
    @Deprecated
    public List<Location> getLocations(FeatureIdentifier identifier, String ... filenames) {
        return this.getLocations(identifier, (List<String>)ImmutableList.copyOf((Object[])filenames));
    }

    @Override
    @Deprecated
    public List<Location> getLocations(FeatureIdentifier identifier, List<String> filenames) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String filename : filenames) {
            locations.add(this.getLocation(identifier, filename));
        }
        return locations;
    }

    @Override
    @Deprecated
    public Location getLocation(FeatureIdentifier identifier, String filename) {
        Project project = this.projectService.getProject(identifier.getProject());
        String value = ProjectUtils.getClasspathPrefix(identifier) + "/" + filename;
        String encoding = ProjectUtils.getEncoding(project);
        return new Location(value, encoding, this.cache);
    }

    @Override
    public Location getLocation(ProjectResource resource) {
        return this.getLocation(resource.getProject(), resource.getPath());
    }
}

