/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kuali.common.util.base.Precondition;

public final class ImmutableProperties
extends Properties {
    private static final long serialVersionUID = 0L;
    private static final String UOE_MSG = "Immutable properties cannot be changed";
    private static final Properties EMPTY = ImmutableProperties.copyOf(new Properties());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableProperties(Properties mutable) {
        Precondition.checkNotNull(mutable, "mutable");
        Properties properties = mutable;
        synchronized (properties) {
            Set<String> keys = mutable.stringPropertyNames();
            Preconditions.checkArgument((keys.size() == mutable.size() ? 1 : 0) != 0, (Object)"Immutable properties only support strings");
            for (String key : keys) {
                super.put(key, mutable.getProperty(key));
            }
        }
    }

    public static Properties of(String name, String value) {
        Properties props = new Properties();
        props.setProperty(name, value);
        return ImmutableProperties.copyOf(props);
    }

    public static Properties of() {
        return EMPTY;
    }

    @Deprecated
    public static Properties of(Properties properties) {
        return ImmutableProperties.copyOf(properties);
    }

    public static ImmutableProperties copyOf(Properties properties) {
        Precondition.checkNotNull(properties, "properties");
        if (properties instanceof ImmutableProperties) {
            return (ImmutableProperties)properties;
        }
        return new ImmutableProperties(properties);
    }

    public static ImmutableProperties copyOf(Map<String, String> map) {
        Precondition.checkNotNull(map, "map");
        Properties properties = new Properties();
        for (String key : map.keySet()) {
            properties.setProperty(key, map.get(key));
        }
        return ImmutableProperties.copyOf(properties);
    }

    @Override
    @Deprecated
    public Object setProperty(String key, String value) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public void load(Reader reader) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public void load(InputStream inStream) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public void loadFromXML(InputStream in) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public Object remove(Object key) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends Object, ? extends Object> t) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public Set<Object> keySet() {
        return ImmutableSet.copyOf(super.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return ImmutableSet.copyOf(super.entrySet());
    }

    @Override
    public Collection<Object> values() {
        return ImmutableList.copyOf(super.values());
    }
}

