/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Properties;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.enc.EncStrength;
import org.kuali.common.util.enc.EncUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;

@Deprecated
public final class DecryptingProcessor
implements PropertyProcessor {
    public static final String DEFAULT_DECRYPT_KEY = "properties.decrypt";
    public static final String DEFAULT_PASSWORD_KEY = "properties.enc.password";
    public static final String DEFAULT_STRENGTH_KEY = "properties.enc.strength";
    private final String decryptKey;
    private final String passwordKey;
    private final String strengthKey;

    public DecryptingProcessor() {
        this(DEFAULT_DECRYPT_KEY, DEFAULT_PASSWORD_KEY, DEFAULT_STRENGTH_KEY);
    }

    public DecryptingProcessor(String passwordKey) {
        this(DEFAULT_DECRYPT_KEY, passwordKey, DEFAULT_STRENGTH_KEY);
    }

    public DecryptingProcessor(String decryptKey, String passwordKey, String strengthKey) {
        this.decryptKey = decryptKey;
        this.passwordKey = passwordKey;
        this.strengthKey = strengthKey;
    }

    @Override
    public void process(Properties properties) {
        boolean decrypt = PropertyUtils.getBoolean(this.decryptKey, properties, false);
        if (decrypt) {
            TextEncryptor encryptor = this.getTextEncryptor(properties);
            PropertyUtils.decrypt(properties, encryptor);
        }
    }

    protected TextEncryptor getTextEncryptor(Properties properties) {
        String password = PropertyUtils.getRequiredResolvedProperty(properties, this.passwordKey);
        String strengthString = PropertyUtils.getRequiredResolvedProperty(properties, this.strengthKey, EncStrength.DEFAULT_VALUE.name());
        EncStrength strength = EncStrength.valueOf(strengthString.toUpperCase());
        return EncUtils.getTextEncryptor(password, strength);
    }

    public String getDecryptKey() {
        return this.decryptKey;
    }

    public String getPasswordKey() {
        return this.passwordKey;
    }

    public String getStrengthKey() {
        return this.strengthKey;
    }
}

