/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.runonce.smart;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.runonce.smart.RunOnce;
import org.kuali.common.util.runonce.smart.RunOnceState;
import org.slf4j.Logger;

public final class PropertiesFileRunOnce
implements RunOnce {
    private static final Logger logger = LoggerUtils.make();
    private final File file;
    private final String encoding;
    private final String key;
    private Properties properties;
    private boolean runonce;
    private boolean initialized = false;

    @Override
    public synchronized void initialize() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        logger.info("--- Initializing properties file backed RunOnce ---");
        this.properties = this.getProperties();
        this.runonce = this.getBoolean(this.properties, this.key);
        this.showConfig();
        logger.info("--- Properties file backed RunOnce initialized. ---");
        this.initialized = true;
    }

    @Override
    public synchronized boolean isTrue() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
        return this.runonce;
    }

    @Override
    public synchronized void changeState(RunOnceState state) {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
        Preconditions.checkNotNull((Object)((Object)state), (Object)"'state' cannot be null");
        this.properties.setProperty(this.key, state.name());
        PropertyUtils.store(this.properties, this.file, this.encoding);
        this.properties = PropertyUtils.load(this.file, this.encoding);
        this.runonce = this.getBoolean(this.properties, this.key);
        Preconditions.checkState((!this.isTrue() ? 1 : 0) != 0, (Object)"isTrue() must return false");
        logger.info("Transitioned RunOnce to - [{}]", (Object)state.name());
    }

    private boolean getBoolean(Properties properties, String key) {
        String value = properties.getProperty(key);
        return Boolean.parseBoolean(value);
    }

    protected void showConfig() {
        logger.info("Properties file: [{}]", (Object)this.file);
        logger.info("Properties file exists: {}", (Object)this.file.exists());
        logger.info("Property: [{}]=[{}]", (Object)this.key, this.properties.get(this.key));
        logger.info("RunOnce: [{}]", (Object)this.runonce);
    }

    protected Properties getProperties() {
        if (this.file.exists()) {
            return PropertyUtils.load(this.file, this.encoding);
        }
        return new Properties();
    }

    private PropertiesFileRunOnce(Builder builder) {
        this.file = builder.file;
        this.encoding = builder.encoding;
        this.key = builder.key;
    }

    public static Builder builder(File file, String encoding, String key) {
        return new Builder(file, encoding, key);
    }

    public File getFile() {
        return this.file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getKey() {
        return this.key;
    }

    public static class Builder {
        private final File file;
        private final String key;
        private final String encoding;

        public Builder(File file, String encoding, String key) {
            this.file = new CanonicalFile(file);
            this.encoding = encoding;
            this.key = key;
        }

        public PropertiesFileRunOnce build() {
            PropertiesFileRunOnce instance = new PropertiesFileRunOnce(this);
            this.validate(instance);
            return instance;
        }

        private void validate(PropertiesFileRunOnce instance) {
            Preconditions.checkNotNull((Object)instance.getFile(), (Object)"file cannot be null");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getEncoding()) ? 1 : 0) != 0, (Object)"encoding cannot be blank");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.getKey()) ? 1 : 0) != 0, (Object)"key cannot be blank");
        }
    }
}

