/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.service.PropertySourceAddPriority;
import org.kuali.common.util.spring.service.PropertySourceContext;
import org.kuali.common.util.spring.service.SpringContext;
import org.kuali.common.util.spring.service.SpringService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class DefaultSpringService
implements SpringService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringService.class);

    @Override
    public void load(Class<?> annotatedClass, Map<String, Object> contextBeans) {
        this.load(annotatedClass, contextBeans, null);
    }

    @Override
    public void load(Class<?> annotatedClass, Map<String, Object> contextBeans, PropertySource<?> propertySource) {
        Assert.notNull(annotatedClass, (String)"annotatedClass is null");
        SpringContext context = new SpringContext();
        context.setAnnotatedClasses(CollectionUtils.asList(annotatedClass));
        context.setPropertySourceContext(new PropertySourceContext(PropertySourceUtils.asList(propertySource)));
        context.setContextBeans(CollectionUtils.toEmptyMap(contextBeans));
        this.load(context);
    }

    @Override
    public void load(String location, Map<String, Object> contextBeans) {
        this.load(location, contextBeans, null);
    }

    protected Map<String, Object> getContextBeans(SpringContext context) {
        Map<String, Object> contextBeans = CollectionUtils.toModifiableEmptyMap(context.getContextBeans());
        CollectionUtils.combine(contextBeans, context.getBeanNames(), context.getBeans());
        return contextBeans;
    }

    protected AbstractApplicationContext getXmlChild(String[] locationsArray, AbstractApplicationContext parent, SpringContext context) {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(locationsArray, false, (ApplicationContext)parent);
        if (parent == null) {
            this.addMetaInfo(ctx, context);
        }
        return ctx;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext(SpringContext context) {
        context.setContextBeans(this.getContextBeans(context));
        context.setAnnotatedClasses(CollectionUtils.toEmptyList(context.getAnnotatedClasses()));
        context.setLocations(CollectionUtils.toEmptyList(context.getLocations()));
        context.setActiveProfiles(CollectionUtils.toEmptyList(context.getActiveProfiles()));
        context.setDefaultProfiles(CollectionUtils.toEmptyList(context.getDefaultProfiles()));
        boolean empty = CollectionUtils.isEmpty(context.getLocations()) && CollectionUtils.isEmpty(context.getAnnotatedClasses());
        Assert.isFalse(empty, "Both locations and annotatedClasses are empty");
        LocationUtils.validateExists(context.getLocations());
        List<String> convertedLocations = this.getConvertedLocations(context.getLocations());
        String[] locationsArray = CollectionUtils.toStringArray(convertedLocations);
        AbstractApplicationContext parent = null;
        if (!CollectionUtils.isEmpty(context.getContextBeans())) {
            parent = SpringUtils.getContextWithPreRegisteredBeans(context.getId(), context.getDisplayName(), context.getContextBeans());
        }
        AbstractApplicationContext child = null;
        if (!CollectionUtils.isEmpty(context.getAnnotatedClasses())) {
            child = this.getAnnotationContext(context, (ConfigurableApplicationContext)parent);
        } else if (!CollectionUtils.isEmpty(context.getLocations())) {
            child = this.getXmlChild(locationsArray, parent, context);
        } else {
            throw new IllegalStateException("Must provide either annotated classes or locations");
        }
        this.addPropertySources(context, (ConfigurableApplicationContext)child);
        this.setDefaultProfiles((ConfigurableApplicationContext)child, context.getDefaultProfiles());
        this.setActiveProfiles((ConfigurableApplicationContext)child, context.getActiveProfiles());
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SpringContext context) {
        ConfigurableApplicationContext ctx = this.getApplicationContext(context);
        try {
            String id = StringUtils.leftPad((String)(Thread.currentThread().getId() + ""), (int)2);
            String name = Thread.currentThread().getName();
            logger.debug("id: " + id + "  name: " + name + " ctx=" + ctx.getClass().getSimpleName() + "@" + Integer.toHexString(ctx.hashCode()));
            ctx.refresh();
            SpringUtils.debugQuietly((ApplicationContext)ctx);
        }
        finally {
            SpringUtils.closeQuietly(ctx);
        }
    }

    @Override
    public void load(String location, Map<String, Object> contextBeans, PropertySource<?> propertySource) {
        Assert.hasText((String)location, (String)"location is null");
        SpringContext context = new SpringContext();
        context.setLocations(Arrays.asList(location));
        context.setPropertySourceContext(new PropertySourceContext(PropertySourceUtils.asList(propertySource)));
        context.setContextBeans(CollectionUtils.toEmptyMap(contextBeans));
        this.load(context);
    }

    @Override
    public void load(Class<?> annotatedClass) {
        this.load(annotatedClass, (String)null, (Object)null);
    }

    @Override
    public void load(String location) {
        this.load(location, (String)null, (Object)null);
    }

    protected void addMetaInfo(AnnotationConfigApplicationContext ctx, SpringContext sc) {
        if (!StringUtils.isBlank((CharSequence)sc.getId())) {
            ctx.setId(sc.getId());
        }
        if (!StringUtils.isBlank((CharSequence)sc.getDisplayName())) {
            ctx.setDisplayName(sc.getDisplayName());
        }
    }

    protected void addMetaInfo(ClassPathXmlApplicationContext ctx, SpringContext sc) {
        if (!StringUtils.isBlank((CharSequence)sc.getId())) {
            ctx.setId(sc.getId());
        }
        if (!StringUtils.isBlank((CharSequence)sc.getDisplayName())) {
            ctx.setDisplayName(sc.getDisplayName());
        }
    }

    protected AbstractApplicationContext getAnnotationContext(SpringContext context, ConfigurableApplicationContext parent) {
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        if (parent != null) {
            ctx.setParent((ApplicationContext)parent);
        } else {
            this.addMetaInfo(ctx, context);
        }
        for (Class<?> annotatedClass : context.getAnnotatedClasses()) {
            ctx.register(new Class[]{annotatedClass});
        }
        return ctx;
    }

    protected void setActiveProfiles(ConfigurableApplicationContext applicationContext, List<String> activeProfiles) {
        if (!CollectionUtils.isEmpty(activeProfiles)) {
            ConfigurableEnvironment env = applicationContext.getEnvironment();
            env.setActiveProfiles(CollectionUtils.toStringArray(activeProfiles));
        }
    }

    protected void setDefaultProfiles(ConfigurableApplicationContext applicationContext, List<String> defaultProfiles) {
        if (!CollectionUtils.isEmpty(defaultProfiles)) {
            ConfigurableEnvironment env = applicationContext.getEnvironment();
            env.setDefaultProfiles(CollectionUtils.toStringArray(defaultProfiles));
        }
    }

    protected void addPropertySources(SpringContext context, ConfigurableApplicationContext applicationContext) {
        PropertySourceContext psc = context.getPropertySourceContext();
        if (psc == null) {
            return;
        }
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        if (psc.isRemoveExistingSources()) {
            logger.debug("Removing all existing property sources");
            PropertySourceUtils.removeAllPropertySources(env);
        }
        if (CollectionUtils.isEmpty(psc.getSources())) {
            return;
        }
        List<PropertySource<?>> propertySources = psc.getSources();
        MutablePropertySources sources = env.getPropertySources();
        if (psc.isLastOneInWins()) {
            Collections.reverse(propertySources);
        }
        PropertySourceAddPriority priority = psc.getPriority();
        block4: for (PropertySource<?> propertySource : propertySources) {
            Object[] args = new Object[]{propertySource.getName(), propertySource.getClass().getName(), priority};
            logger.debug("Adding property source - [{}] -> [{}] Priority=[{}]", args);
            switch (priority) {
                case FIRST: {
                    sources.addFirst(propertySource);
                    continue block4;
                }
                case LAST: {
                    sources.addLast(propertySource);
                    continue block4;
                }
            }
            throw new IllegalStateException((Object)((Object)priority) + " is an unknown priority");
        }
    }

    protected List<String> getConvertedLocations(List<String> locations) {
        ArrayList<String> converted = new ArrayList<String>();
        for (String location : locations) {
            if (LocationUtils.isExistingFile(location)) {
                File file = new File(location);
                String url = LocationUtils.getCanonicalURLString(file);
                converted.add(url);
                continue;
            }
            converted.add(location);
        }
        return converted;
    }

    @Override
    @Deprecated
    public void load(Class<?> annotatedClass, String beanName, Object bean, PropertySource<?> propertySource) {
        this.load(annotatedClass, CollectionUtils.toEmptyMap(beanName, bean), propertySource);
    }

    @Override
    @Deprecated
    public void load(Class<?> annotatedClass, String beanName, Object bean) {
        this.load(annotatedClass, beanName, bean, null);
    }

    @Override
    @Deprecated
    public void load(String location, String beanName, Object bean, PropertySource<?> propertySource) {
        this.load(location, CollectionUtils.toEmptyMap(beanName, bean), propertySource);
    }

    @Override
    @Deprecated
    public void load(String location, String beanName, Object bean) {
        this.load(location, beanName, bean, null);
    }
}

