/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.service;

import java.util.List;
import java.util.Map;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.spring.service.PropertySourceContext;

public class SpringContext {
    String id;
    String displayName;
    List<String> locations;
    List<Class<?>> annotatedClasses;
    Map<String, Object> contextBeans;
    PropertySourceContext propertySourceContext;
    List<String> activeProfiles;
    List<String> defaultProfiles;
    @Deprecated
    List<String> beanNames;
    @Deprecated
    List<Object> beans;

    public SpringContext(Map<String, Object> beans, Class<?> annotatedClass) {
        this(beans, CollectionUtils.asList(annotatedClass), (String)null);
    }

    public SpringContext(Map<String, Object> beans, Class<?> annotatedClass, String activeProfile) {
        this(beans, CollectionUtils.asList(annotatedClass), null, CollectionUtils.toEmptyList(activeProfile));
    }

    public SpringContext(Map<String, Object> beans, List<Class<?>> annotatedClasses, String activeProfile) {
        this(beans, annotatedClasses, null, CollectionUtils.toEmptyList(activeProfile));
    }

    public SpringContext(PropertySourceContext propertySourceContext) {
        this((Class)null, propertySourceContext);
    }

    public SpringContext() {
        this((Class)null);
    }

    public SpringContext(Class<?> annotatedClass) {
        this(CollectionUtils.asList(annotatedClass));
    }

    public SpringContext(Class<?> annotatedClass, PropertySourceContext propertySourceContext) {
        this(CollectionUtils.asList(annotatedClass), propertySourceContext);
    }

    public SpringContext(List<Class<?>> annotatedClasses) {
        this(annotatedClasses, null);
    }

    public SpringContext(List<Class<?>> annotatedClasses, PropertySourceContext propertySourceContext) {
        this(null, annotatedClasses, propertySourceContext);
    }

    public SpringContext(Map<String, Object> contextBeans, List<Class<?>> annotatedClasses, PropertySourceContext propertySourceContext) {
        this(contextBeans, annotatedClasses, propertySourceContext, null);
    }

    public SpringContext(Map<String, Object> contextBeans, List<Class<?>> annotatedClasses, PropertySourceContext propertySourceContext, List<String> activeProfiles) {
        this.contextBeans = contextBeans;
        this.annotatedClasses = annotatedClasses;
        this.propertySourceContext = propertySourceContext;
        this.activeProfiles = activeProfiles;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public List<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedClasses(List<Class<?>> annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    @Deprecated
    public List<String> getBeanNames() {
        return this.beanNames;
    }

    @Deprecated
    public void setBeanNames(List<String> beanNames) {
        this.beanNames = beanNames;
    }

    @Deprecated
    public List<Object> getBeans() {
        return this.beans;
    }

    @Deprecated
    public void setBeans(List<Object> beans) {
        this.beans = beans;
    }

    public PropertySourceContext getPropertySourceContext() {
        return this.propertySourceContext;
    }

    public void setPropertySourceContext(PropertySourceContext propertySourceContext) {
        this.propertySourceContext = propertySourceContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public List<String> getDefaultProfiles() {
        return this.defaultProfiles;
    }

    public void setDefaultProfiles(List<String> defaultProfiles) {
        this.defaultProfiles = defaultProfiles;
    }

    public Map<String, Object> getContextBeans() {
        return this.contextBeans;
    }

    public void setContextBeans(Map<String, Object> contextBeans) {
        this.contextBeans = contextBeans;
    }
}

