/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Artifact;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Dependency;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.nullify.NullUtils;

@Deprecated
public class RepositoryUtils {
    private static final String FS = File.separator;
    private static final String DEFAULT_MAVEN_REPO_PATH = ".m2" + FS + "repository";
    private static final String GAV_DELIMITER = ":";

    public static final void copyArtifact(String repository, Artifact artifact) {
        File file = RepositoryUtils.getFile(artifact);
        RepositoryUtils.copyArtifactToFile(repository, artifact, file);
    }

    public static final void copyArtifactToDirectory(String repository, Artifact artifact, File directory) {
        String filename = RepositoryUtils.getFilename(artifact);
        File file = new File(directory, filename);
        RepositoryUtils.copyArtifactToFile(repository, artifact, file);
    }

    public static final void copyArtifactToFile(String repository, Artifact artifact, File file) {
        String location = repository + RepositoryUtils.getRepositoryPath(artifact);
        LocationUtils.copyLocationToFile(location, file);
    }

    public static final String toString(Artifact artifact) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(RepositoryUtils.toEmpty(artifact.getGroupId()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getArtifactId()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getVersion()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getClassifier()));
        tokens.add(RepositoryUtils.toEmpty(artifact.getType()));
        int delimiterCount = RepositoryUtils.getDelimiterCount(tokens);
        return RepositoryUtils.getDelimitedString(tokens, delimiterCount, GAV_DELIMITER);
    }

    public static final String toString(Dependency dependency) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(RepositoryUtils.toEmpty(dependency.getGroupId()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getArtifactId()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getVersion()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getClassifier()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getType()));
        tokens.add(RepositoryUtils.toEmpty(dependency.getScope()));
        int delimiterCount = RepositoryUtils.getDelimiterCount(tokens);
        return RepositoryUtils.getDelimitedString(tokens, delimiterCount, GAV_DELIMITER);
    }

    public static final Artifact parseArtifact(String gav) {
        Assert.hasText((String)gav, (String)"gav has no text");
        String[] tokens = StringUtils.splitPreserveAllTokens((String)gav, (String)GAV_DELIMITER);
        int len = tokens.length;
        for (int i = 0; i < len; ++i) {
            tokens[i] = RepositoryUtils.toNull(tokens[i]);
        }
        Artifact a = new Artifact();
        if (len > 0) {
            a.setGroupId(tokens[0]);
        }
        if (len > 1) {
            a.setArtifactId(tokens[1]);
        }
        if (len > 2) {
            a.setVersion(tokens[2]);
        }
        if (len > 3) {
            a.setClassifier(tokens[3]);
        }
        if (len > 4) {
            a.setType(tokens[4]);
        }
        return a;
    }

    public static final Dependency parseDependency(String gav) {
        Assert.hasText((String)gav, (String)"gav has no text");
        String[] tokens = StringUtils.splitPreserveAllTokens((String)gav, (String)GAV_DELIMITER);
        int len = tokens.length;
        for (int i = 0; i < len; ++i) {
            tokens[i] = RepositoryUtils.toNull(tokens[i]);
        }
        Dependency d = new Dependency();
        if (len > 0) {
            d.setGroupId(tokens[0]);
        }
        if (len > 1) {
            d.setArtifactId(tokens[1]);
        }
        if (len > 2) {
            d.setVersion(tokens[2]);
        }
        if (len > 3) {
            d.setClassifier(tokens[3]);
        }
        if (len > 4) {
            d.setType(tokens[4]);
        }
        if (len > 5) {
            d.setScope(tokens[5]);
        }
        return d;
    }

    protected static final String getDelimitedString(List<String> tokens, int delimiterCount, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i != 0 && i < delimiterCount) {
                sb.append(delimiter);
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    protected static final int getDelimiterCount(List<String> tokens) {
        int count = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = RepositoryUtils.toEmpty(tokens.get(i));
            if (StringUtils.isEmpty((CharSequence)token)) continue;
            count = i + 1;
        }
        return count == 0 ? tokens.size() : count;
    }

    public static String toNull(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        if (NullUtils.isNullOrNone(token)) {
            return null;
        }
        return token;
    }

    public static String toEmpty(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return "";
        }
        if (NullUtils.isNullOrNone(token)) {
            return "";
        }
        return token;
    }

    public static final String getRepositoryPath(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(Str.getPath(artifact.getGroupId()));
        sb.append(FS);
        sb.append(artifact.getArtifactId());
        sb.append(FS);
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    protected static boolean addClassifierToFilename(String classifier) {
        return !StringUtils.isBlank((CharSequence)classifier) && !NullUtils.isNullOrNone(classifier);
    }

    public static final String getFilename(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId());
        sb.append("-");
        sb.append(artifact.getVersion());
        if (RepositoryUtils.addClassifierToFilename(artifact.getClassifier())) {
            sb.append("-");
            sb.append(artifact.getClassifier());
        }
        sb.append(".");
        sb.append(artifact.getType());
        return sb.toString();
    }

    public static final File getDefaultLocalRepositoryDir() {
        return new File(FileUtils.getUserDirectoryPath() + FS + DEFAULT_MAVEN_REPO_PATH);
    }

    public static final File getFile(Artifact artifact) {
        return RepositoryUtils.getFile(RepositoryUtils.getDefaultLocalRepositoryDir(), artifact);
    }

    public static final File getFile(File localRepositoryDir, Artifact artifact) {
        String path = RepositoryUtils.getRepositoryPath(artifact);
        String filename = RepositoryUtils.getFilename(artifact);
        return new File(localRepositoryDir.getAbsolutePath() + FS + path, filename);
    }
}

