/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.Version;

public class VersionUtils {
    public static final String MAVEN_SNAPSHOT_TOKEN = "SNAPSHOT";
    private static final String[] DELIMITERS = new String[]{".", "-"};
    private static final String SEPARATOR_CHARS = Str.toString(DELIMITERS);

    public static final boolean isSnapshot(String version) {
        for (String delimiter : DELIMITERS) {
            String suffix = delimiter + MAVEN_SNAPSHOT_TOKEN;
            if (!StringUtils.endsWithIgnoreCase((CharSequence)version, (CharSequence)suffix)) continue;
            return true;
        }
        return false;
    }

    public static final String trimSnapshot(String version) {
        if (VersionUtils.isSnapshot(version)) {
            int length = MAVEN_SNAPSHOT_TOKEN.length() + 1;
            return StringUtils.left((String)version, (int)(version.length() - length));
        }
        return version;
    }

    public static final Version getVersion(String version) {
        boolean snapshot = VersionUtils.isSnapshot(version);
        String trimmed = VersionUtils.trimSnapshot(version);
        Version v = new Version();
        v.setTrimmed(trimmed);
        v.setSnapshot(snapshot);
        String[] tokens = StringUtils.split((String)trimmed, (String)SEPARATOR_CHARS);
        if (tokens.length > 0) {
            v.setMajor(tokens[0]);
        }
        if (tokens.length > 1) {
            v.setMinor(tokens[1]);
        }
        if (tokens.length > 2) {
            v.setIncremental(tokens[2]);
        }
        String qualifier = VersionUtils.getQualifier(trimmed, tokens);
        v.setQualifier(qualifier);
        return v;
    }

    public static String asSanitizedString(Version version) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.trimToEmpty((String)version.getMajor()));
        sb.append(StringUtils.trimToEmpty((String)version.getMinor()));
        sb.append(StringUtils.trimToEmpty((String)version.getIncremental()));
        sb.append(StringUtils.trimToEmpty((String)version.getQualifier()));
        return VersionUtils.sanitize(sb.toString());
    }

    protected static String sanitize(String s) {
        s = StringUtils.replace((String)s, (String)".", (String)"_");
        s = StringUtils.replace((String)s, (String)"-", (String)"_");
        return StringUtils.upperCase((String)s);
    }

    public static final String getSanitizedQualifier(String qualifier) {
        if (qualifier == null) {
            return null;
        }
        return VersionUtils.sanitize(qualifier);
    }

    protected static final String getQualifier(String trimmed, String[] tokens) {
        if (tokens.length < 4) {
            return null;
        }
        int pos = tokens[0].length() + 1 + tokens[1].length() + 1 + tokens[2].length() + 1;
        return trimmed.substring(pos);
    }
}

