/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.impl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.base.Threads;
import org.kuali.common.util.channel.api.SecureChannel;
import org.kuali.common.util.channel.impl.StreamHandler;
import org.kuali.common.util.channel.model.ChannelContext;
import org.kuali.common.util.channel.model.CommandContext;
import org.kuali.common.util.channel.model.CommandResult;
import org.kuali.common.util.channel.model.CopyDirection;
import org.kuali.common.util.channel.model.CopyResult;
import org.kuali.common.util.channel.model.RemoteFile;
import org.kuali.common.util.channel.model.Status;
import org.kuali.common.util.channel.util.ChannelUtils;
import org.kuali.common.util.channel.util.SSHUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSecureChannel
implements SecureChannel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecureChannel.class);
    private static final String SFTP = "sftp";
    private static final String EXEC = "exec";
    private static final String FORWARDSLASH = "/";
    private final Session session;
    private final ChannelSftp sftp;
    private final ChannelContext context;
    private boolean closed = false;

    public DefaultSecureChannel(ChannelContext context) throws IOException {
        Assert.noNulls(context);
        this.context = context;
        this.log();
        try {
            JSch jsch = this.getJSch();
            this.session = this.openSession(jsch);
            this.sftp = this.openSftpChannel(this.session, context.getConnectTimeout());
        }
        catch (JSchException e) {
            throw new IOException("Unexpected error opening secure channel", e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.context.isEcho()) {
            logger.info("Closing secure channel [{}]", (Object)ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname()));
        } else {
            logger.debug("Closing secure channel [{}]", (Object)ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname()));
        }
        this.closeQuietly((Channel)this.sftp);
        this.closeQuietly(this.session);
        this.closed = true;
    }

    @Override
    public List<CommandResult> exec(String ... commands) {
        ArrayList<CommandResult> results = new ArrayList<CommandResult>();
        ImmutableList copy = ImmutableList.copyOf((Object[])commands);
        for (String command : copy) {
            CommandResult result = this.exec(command);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<CommandResult> exec(CommandContext ... contexts) {
        ArrayList<CommandResult> results = new ArrayList<CommandResult>();
        ImmutableList copy = ImmutableList.copyOf((Object[])contexts);
        for (CommandContext context : copy) {
            CommandResult result = this.exec(context);
            results.add(result);
        }
        return results;
    }

    @Override
    public CommandResult exec(String command) {
        return this.exec(new CommandContext.Builder(command).build());
    }

    @Override
    public CommandResult exec(CommandContext context) {
        StreamHandler handler = new StreamHandler(context);
        ChannelExec exec = null;
        try {
            long start = System.currentTimeMillis();
            exec = this.getChannelExec();
            exec.setCommand(context.getCommand());
            exec.setInputStream((InputStream)context.getStdin().orNull());
            handler.openStreams(exec, this.context.getEncoding());
            handler.startPumping();
            this.connect((Channel)exec, context.getTimeout());
            this.waitForClosed(exec, this.context.getWaitForClosedSleepMillis());
            handler.waitUntilDone();
            handler.validate();
            CommandResult result = new CommandResult(context.getCommand(), exec.getExitStatus(), start);
            this.validate(context, result);
            if (this.context.isEcho()) {
                String elapsed = FormatUtils.getTime(result.getElapsed());
                logger.info("{} - [{}]", (Object)new String(context.getCommand(), this.context.getEncoding()), (Object)elapsed);
            }
            CommandResult commandResult = result;
            return commandResult;
        }
        catch (Exception e) {
            handler.disableQuietly();
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)((InputStream)context.getStdin().orNull()));
            this.closeQuietly((Channel)exec);
            handler.closeQuietly();
        }
    }

    protected void validate(CommandContext context, CommandResult result) {
        if (context.isIgnoreExitValue()) {
            return;
        }
        if (context.getSuccessCodes().size() == 0) {
            return;
        }
        List<Integer> codes = context.getSuccessCodes();
        int exitValue = result.getExitValue();
        for (int successCode : codes) {
            if (exitValue != successCode) continue;
            return;
        }
        throw new IllegalStateException("Command exited with [" + exitValue + "].  Valid values are [" + CollectionUtils.toCSV(codes) + "]");
    }

    protected ChannelExec getChannelExec() throws JSchException {
        ChannelExec exec = (ChannelExec)this.session.openChannel(EXEC);
        if (this.context.isRequestPseudoTerminal()) {
            exec.setPty(true);
        }
        return exec;
    }

    @Override
    public void execNoWait(String command) {
        this.execNoWait(Str.getBytes(command, this.context.getEncoding()));
    }

    @Override
    public void execNoWait(byte[] command) {
        Assert.noNulls(new Object[]{command});
        ChannelExec exec = null;
        try {
            if (this.context.isEcho()) {
                logger.info("{}", (Object)Str.getString(command, this.context.getEncoding()));
            }
            exec = this.getChannelExec();
            exec.setCommand(command);
            this.connect((Channel)exec, (Optional<Integer>)Optional.absent());
            this.closeQuietly((Channel)exec);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((Channel)exec);
                throw throwable;
            }
        }
    }

    protected void waitForClosed(ChannelExec exec, long millis) {
        while (!exec.isClosed()) {
            Threads.sleep(millis);
        }
    }

    @Override
    public RemoteFile getWorkingDirectory() {
        try {
            String workingDirectory = this.sftp.pwd();
            return this.getMetaData(workingDirectory);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void log() {
        if (this.context.isEcho()) {
            logger.info("Opening secure channel [{}] encoding={}", (Object)ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname()), (Object)this.context.getEncoding());
        } else {
            logger.debug("Opening secure channel [{}] encoding={}", (Object)ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname()), (Object)this.context.getEncoding());
        }
        logger.debug("Private key files - {}", (Object)this.context.getPrivateKeyFiles().size());
        logger.debug("Private key strings - {}", (Object)this.context.getPrivateKeys().size());
        logger.debug("Private key config file - {}", (Object)this.context.getConfig());
        logger.debug("Private key config file use - {}", (Object)this.context.isUseConfigFile());
        logger.debug("Include default private key locations - {}", (Object)this.context.isIncludeDefaultPrivateKeyLocations());
        logger.debug("Known hosts file - {}", (Object)this.context.getKnownHosts());
        logger.debug("Port - {}", (Object)this.context.getPort());
        if (this.context.getConnectTimeout().isPresent()) {
            logger.debug("Connect timeout - {}", this.context.getConnectTimeout().get());
        }
        logger.debug("Strict host key checking - {}", (Object)this.context.isStrictHostKeyChecking());
        logger.debug("Configuring channel with {} custom options", (Object)this.context.getOptions().size());
        PropertyUtils.debug(this.context.getOptions());
    }

    protected ChannelSftp openSftpChannel(Session session, Optional<Integer> timeout) throws JSchException {
        ChannelSftp sftp = (ChannelSftp)session.openChannel(SFTP);
        this.connect((Channel)sftp, timeout);
        return sftp;
    }

    protected void connect(Channel channel, Optional<Integer> timeout) throws JSchException {
        if (timeout.isPresent()) {
            channel.connect(((Integer)timeout.get()).intValue());
        } else {
            channel.connect();
        }
    }

    protected void closeQuietly(Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected void closeQuietly(Channel channel) {
        if (channel != null) {
            channel.disconnect();
        }
    }

    protected Session openSession(JSch jsch) throws JSchException {
        Session session = jsch.getSession((String)this.context.getUsername().orNull(), this.context.getHostname(), this.context.getPort());
        session.setConfig(this.context.getOptions());
        if (this.context.getConnectTimeout().isPresent()) {
            session.connect(((Integer)this.context.getConnectTimeout().get()).intValue());
        } else {
            session.connect();
        }
        return session;
    }

    protected JSch getJSch() {
        try {
            JSch jsch = this.getJSch(this.context.getPrivateKeyFiles(), this.context.getPrivateKeys());
            File knownHosts = this.context.getKnownHosts();
            if (this.context.isUseKnownHosts() && knownHosts.exists()) {
                String path = LocationUtils.getCanonicalPath(knownHosts);
                jsch.setKnownHosts(path);
            }
            return jsch;
        }
        catch (JSchException e) {
            throw new IllegalStateException("Unexpected error", e);
        }
    }

    protected JSch getJSch(List<File> privateKeys, List<String> privateKeyStrings) throws JSchException {
        JSch jsch = new JSch();
        for (File privateKey : privateKeys) {
            String path = LocationUtils.getCanonicalPath(privateKey);
            jsch.addIdentity(path);
        }
        int count = 0;
        for (String privateKeyString : privateKeyStrings) {
            String name = "privateKeyString-" + Integer.toString(count++);
            byte[] bytes = Str.getBytes(privateKeyString, this.context.getEncoding());
            jsch.addIdentity(name, bytes, null, null);
        }
        return jsch;
    }

    protected static List<File> getUniquePrivateKeyFiles(List<File> privateKeys, boolean useConfigFile, File config, boolean includeDefaultPrivateKeyLocations) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File privateKey : privateKeys) {
            paths.add(LocationUtils.getCanonicalPath(privateKey));
        }
        if (useConfigFile) {
            for (String path : SSHUtils.getFilenames(config)) {
                paths.add(path);
            }
        }
        if (includeDefaultPrivateKeyLocations) {
            for (String path : SSHUtils.PRIVATE_KEY_DEFAULTS) {
                paths.add(path);
            }
        }
        List<String> uniquePaths = CollectionUtils.getUniqueStrings(paths);
        return SSHUtils.getExistingAndReadable(uniquePaths);
    }

    @Override
    public RemoteFile getMetaData(String absolutePath) {
        Assert.noBlanks(absolutePath);
        return this.fillInAttributes(absolutePath);
    }

    @Override
    public void deleteFile(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        if (this.isStatus(file, Status.MISSING)) {
            return;
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname(), file) + "] is a directory.");
        }
        try {
            this.sftp.rm(absolutePath);
            if (this.context.isEcho()) {
                logger.info("deleted -> [{}]", (Object)absolutePath);
            }
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean exists(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS);
    }

    @Override
    public boolean isDirectory(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS) && file.isDirectory();
    }

    protected RemoteFile fillInAttributes(String path) {
        try {
            SftpATTRS attributes = this.sftp.stat(path);
            return this.fillInAttributes(path, attributes);
        }
        catch (SftpException e) {
            return this.handleNoSuchFileException(path, e);
        }
    }

    protected RemoteFile fillInAttributes(String path, SftpATTRS attributes) {
        boolean directory = attributes.isDir();
        int permissions = attributes.getPermissions();
        int userId = attributes.getUId();
        int groupId = attributes.getGId();
        long size = attributes.getSize();
        Status status = Status.EXISTS;
        return new RemoteFile.Builder(path).directory(directory).permissions(permissions).userId(userId).groupId(groupId).size(size).status(status).build();
    }

    @Override
    public CopyResult scp(File source, RemoteFile destination) {
        Assert.notNull((Object)source);
        Assert.exists(source);
        Assert.isFalse(source.isDirectory(), "[" + source + "] is a directory");
        Assert.isTrue((boolean)source.canRead(), (String)("[" + source + "] not readable"));
        return this.scp(LocationUtils.getCanonicalURLString(source), destination);
    }

    @Override
    public CopyResult scpToDir(File source, RemoteFile directory) {
        String filename = source.getName();
        String absolutePath = this.getAbsolutePath(directory.getAbsolutePath(), filename);
        RemoteFile file = new RemoteFile.Builder(absolutePath).clone(directory).build();
        return this.scp(source, file);
    }

    @Override
    public CopyResult scp(String location, RemoteFile destination) {
        Assert.notNull((Object)location);
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)(location + " does not exist"));
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            CopyResult copyResult = this.scp(in, destination);
            return copyResult;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public CopyResult scpString(String string, RemoteFile destination) {
        Assert.notNull((Object)string);
        ByteArrayInputStream in = new ByteArrayInputStream(Str.getBytes(string, this.context.getEncoding()));
        CopyResult result = this.scp(in, destination);
        IOUtils.closeQuietly((InputStream)in);
        return result;
    }

    @Override
    public String toString(RemoteFile source) {
        Assert.notNull((Object)source);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.scp(source, (OutputStream)out);
            String string = out.toString(this.context.getEncoding());
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public CopyResult scp(InputStream source, RemoteFile destination) {
        Assert.notNull((Object)source);
        try {
            long start = System.currentTimeMillis();
            this.createDirectories(destination);
            this.sftp.put(source, destination.getAbsolutePath());
            RemoteFile meta = this.getMetaData(destination.getAbsolutePath());
            CopyResult result = new CopyResult(start, (Long)meta.getSize().get(), CopyDirection.TO_REMOTE);
            this.to(destination, result);
            return result;
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getAbsolutePath(String absolutePath, String filename) {
        if (StringUtils.endsWith((CharSequence)absolutePath, (CharSequence)FORWARDSLASH)) {
            return absolutePath + filename;
        }
        return absolutePath + FORWARDSLASH + filename;
    }

    @Override
    public CopyResult scpToDir(String location, RemoteFile directory) {
        String filename = LocationUtils.getFilename(location);
        String absolutePath = this.getAbsolutePath(directory.getAbsolutePath(), filename);
        RemoteFile file = new RemoteFile.Builder(absolutePath).clone(directory).build();
        return this.scp(location, file);
    }

    @Override
    public CopyResult scp(RemoteFile source, File destination) {
        CopyResult copyResult;
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(FileUtils.openOutputStream((File)destination));
            copyResult = this.scp(source, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return copyResult;
    }

    @Override
    public CopyResult scp(String absolutePath, OutputStream out) throws IOException {
        try {
            long start = System.currentTimeMillis();
            this.sftp.get(absolutePath, out);
            RemoteFile meta = this.getMetaData(absolutePath);
            CopyResult result = new CopyResult(start, (Long)meta.getSize().get(), CopyDirection.FROM_REMOTE);
            this.from(absolutePath, result);
            return result;
        }
        catch (SftpException e) {
            throw new IOException("Unexpected IO error", e);
        }
    }

    protected void to(RemoteFile destination, CopyResult result) {
        if (this.context.isEcho()) {
            String elapsed = FormatUtils.getTime(result.getElapsedMillis());
            String rate = FormatUtils.getRate(result.getElapsedMillis(), result.getAmountInBytes());
            Object[] args = new Object[]{destination.getAbsolutePath(), elapsed, rate};
            logger.info("created -> [{}] - [{}, {}]", args);
        }
    }

    protected void from(String absolutePath, CopyResult result) {
        if (this.context.isEcho()) {
            String elapsed = FormatUtils.getTime(result.getElapsedMillis());
            String rate = FormatUtils.getRate(result.getElapsedMillis(), result.getAmountInBytes());
            Object[] args = new Object[]{absolutePath, elapsed, rate};
            logger.info("copied <- [{}] - [{}, {}]", args);
        }
    }

    @Override
    public CopyResult scp(RemoteFile source, OutputStream out) throws IOException {
        return this.scp(source.getAbsolutePath(), out);
    }

    @Override
    public CopyResult scpToDir(RemoteFile source, File destination) {
        String filename = FilenameUtils.getName((String)source.getAbsolutePath());
        File newDestination = new File(destination, filename);
        return this.scp(source, newDestination);
    }

    @Override
    public void createDirectory(RemoteFile dir) {
        Assert.isTrue((boolean)dir.isDirectory());
        try {
            this.createDirectories(dir);
            if (this.context.isEcho()) {
                logger.info("mkdir -> [{}]", (Object)dir.getAbsolutePath());
            }
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createDirectories(RemoteFile file) throws SftpException {
        boolean directoryIndicator = file.isDirectory();
        RemoteFile remoteFile = this.fillInAttributes(file.getAbsolutePath());
        this.validate(remoteFile, directoryIndicator);
        List<String> directories = LocationUtils.getNormalizedPathFragments(file.getAbsolutePath(), file.isDirectory());
        for (String directory : directories) {
            RemoteFile parentDir = this.fillInAttributes(directory);
            this.validate(parentDir, true);
            if (this.isStatus(parentDir, Status.EXISTS)) continue;
            this.mkdir(parentDir);
        }
    }

    protected boolean isStatus(RemoteFile file, Status status) {
        Optional<Status> remoteStatus = file.getStatus();
        if (remoteStatus.isPresent()) {
            return ((Status)((Object)remoteStatus.get())).equals((Object)status);
        }
        return false;
    }

    protected void validate(RemoteFile file, boolean directoryIndicator) {
        Assert.isTrue((boolean)file.getStatus().isPresent());
        boolean missing = this.isStatus(file, Status.MISSING);
        boolean exists = this.isStatus(file, Status.EXISTS);
        boolean correctFileType = file.isDirectory() == directoryIndicator;
        boolean valid = missing || exists && correctFileType;
        Assert.isTrue((boolean)valid, (String)this.getInvalidExistingFileMessage(file));
    }

    protected String getInvalidExistingFileMessage(RemoteFile existing) {
        if (existing.isDirectory()) {
            return "[" + ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname(), existing) + "] is an existing directory. Unable to create file.";
        }
        return "[" + ChannelUtils.getLocation(this.context.getUsername(), this.context.getHostname(), existing) + "] is an existing file. Unable to create directory.";
    }

    protected void mkdir(RemoteFile dir) {
        try {
            String path = dir.getAbsolutePath();
            logger.debug("Creating [{}]", (Object)path);
            this.sftp.mkdir(path);
            this.setAttributes(dir);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setAttributes(RemoteFile file) throws SftpException {
        String path = file.getAbsolutePath();
        if (file.getPermissions().isPresent()) {
            this.sftp.chmod(((Integer)file.getPermissions().get()).intValue(), path);
        }
        if (file.getGroupId().isPresent()) {
            this.sftp.chgrp(((Integer)file.getGroupId().get()).intValue(), path);
        }
        if (file.getUserId().isPresent()) {
            this.sftp.chown(((Integer)file.getUserId().get()).intValue(), path);
        }
    }

    protected RemoteFile handleNoSuchFileException(String path, SftpException e) {
        if (this.isNoSuchFileException(e)) {
            return new RemoteFile.Builder(path).status(Status.MISSING).build();
        }
        throw new IllegalStateException(e);
    }

    protected boolean isNoSuchFileException(SftpException exception) {
        return exception.id == 2;
    }
}

