/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.model;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.channel.util.SSHUtils;
import org.kuali.common.util.enc.EncUtils;
import org.kuali.common.util.enc.EncryptionService;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.property.ImmutableProperties;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;

public final class ChannelContext {
    private final Optional<String> username;
    private final String hostname;
    private final List<String> privateKeys;
    private final int port;
    private final String encoding;
    private final boolean strictHostKeyChecking;
    private final boolean requestPseudoTerminal;
    private final Optional<Integer> connectTimeout;
    private final Properties options;
    private final File knownHosts;
    private final File config;
    private final boolean useConfigFile;
    private final boolean useKnownHosts;
    private final boolean includeDefaultPrivateKeyLocations;
    private final int waitForClosedSleepMillis;
    private final List<File> privateKeyFiles;
    private final boolean echo;

    private ChannelContext(Builder builder) {
        this.username = builder.username;
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.encoding = builder.encoding;
        this.connectTimeout = builder.connectTimeout;
        this.options = builder.options;
        this.strictHostKeyChecking = builder.strictHostKeyChecking;
        this.requestPseudoTerminal = builder.requestPseudoTerminal;
        this.knownHosts = builder.knownHosts;
        this.config = builder.config;
        this.useConfigFile = builder.useConfigFile;
        this.includeDefaultPrivateKeyLocations = builder.includeDefaultPrivateKeyLocations;
        this.waitForClosedSleepMillis = builder.waitForClosedSleepMillis;
        this.privateKeyFiles = builder.privateKeyFiles;
        this.privateKeys = builder.privateKeys;
        this.useKnownHosts = builder.useKnownHosts;
        this.echo = builder.echo;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Optional<Integer> getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Properties getOptions() {
        return this.options;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public boolean isRequestPseudoTerminal() {
        return this.requestPseudoTerminal;
    }

    public File getKnownHosts() {
        return this.knownHosts;
    }

    public File getConfig() {
        return this.config;
    }

    public boolean isUseConfigFile() {
        return this.useConfigFile;
    }

    public boolean isUseKnownHosts() {
        return this.useKnownHosts;
    }

    public boolean isIncludeDefaultPrivateKeyLocations() {
        return this.includeDefaultPrivateKeyLocations;
    }

    public int getWaitForClosedSleepMillis() {
        return this.waitForClosedSleepMillis;
    }

    public List<File> getPrivateKeyFiles() {
        return this.privateKeyFiles;
    }

    public List<String> getPrivateKeys() {
        return this.privateKeys;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public static class Builder {
        private final String hostname;
        private Optional<String> username = Optional.absent();
        private int port = 22;
        private Optional<Integer> connectTimeout = Optional.absent();
        private String encoding = Charsets.UTF_8.name();
        private Properties options = ImmutableProperties.of();
        private boolean strictHostKeyChecking = false;
        private boolean requestPseudoTerminal = false;
        private File knownHosts = SSHUtils.DEFAULT_KNOWN_HOSTS;
        private boolean useKnownHosts = false;
        private File config = SSHUtils.DEFAULT_CONFIG_FILE;
        private boolean useConfigFile = false;
        private boolean includeDefaultPrivateKeyLocations = false;
        private int waitForClosedSleepMillis = 10;
        private List<File> privateKeyFiles = ImmutableList.of();
        private List<String> privateKeys = ImmutableList.of();
        private boolean echo = true;
        private final Optional<EnvironmentService> env;
        private final Optional<EncryptionService> enc;
        private static final String HOSTNAME_KEY = "ssh.hostname";
        private static final String USERNAME_KEY = "ssh.username";
        private static final String REQUEST_PSEUDO_TERMINAL_KEY = "ssh.requestPseudoTerminal";
        private static final String PRIVATE_KEYS_KEY = "ssh.privateKeys";
        private static final String ECHO_KEY = "ssh.echo";
        private static final String PORT_KEY = "ssh.port";
        private static final String ENCODING_KEY = "ssh.encoding";
        private static final String CONNECT_TIMEOUT_KEY = "ssh.connectTimeout";

        public Builder(String hostname) {
            this(EnvUtils.ABSENT, EncUtils.ABSENT, hostname);
        }

        public Builder(EnvironmentService env, String hostname) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), EncUtils.ABSENT, hostname);
        }

        public Builder(EnvironmentService env, EncryptionService enc, String hostname) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), (Optional<EncryptionService>)Optional.of((Object)enc), hostname);
        }

        private Builder(Optional<EnvironmentService> env, Optional<EncryptionService> enc, String hostname) {
            this.hostname = env.isPresent() ? ((EnvironmentService)env.get()).getString(HOSTNAME_KEY, hostname) : hostname;
            this.env = env;
            this.enc = enc;
        }

        public Builder requestPseudoTerminal(boolean requestPseudoTerminal) {
            this.requestPseudoTerminal = requestPseudoTerminal;
            return this;
        }

        public Builder echo(boolean echo) {
            this.echo = echo;
            return this;
        }

        public Builder username(String username) {
            this.username = NullUtils.toAbsent(username);
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = Optional.of((Object)connectTimeout);
            return this;
        }

        public Builder options(Properties options) {
            this.options = options;
            return this;
        }

        public Builder knownHosts(File knownHosts) {
            this.knownHosts = knownHosts;
            return this;
        }

        public Builder useKnownHosts(boolean useKnownHosts) {
            this.useKnownHosts = useKnownHosts;
            return this;
        }

        public Builder config(File config) {
            this.config = config;
            return this;
        }

        public Builder useConfigFile(boolean useConfigFile) {
            this.useConfigFile = useConfigFile;
            return this;
        }

        public Builder includeDefaultPrivateKeyLocations(boolean includeDefaultPrivateKeyLocations) {
            this.includeDefaultPrivateKeyLocations = includeDefaultPrivateKeyLocations;
            return this;
        }

        public Builder waitForClosedSleepMillis(int waitForClosedSleepMillis) {
            this.waitForClosedSleepMillis = waitForClosedSleepMillis;
            return this;
        }

        public Builder privateKeyFiles(List<File> privateKeyFiles) {
            this.privateKeyFiles = privateKeyFiles;
            return this;
        }

        public Builder privateKey(String privateKey) {
            Optional<String> trimmed = NullUtils.toAbsent(privateKey);
            if (trimmed.isPresent()) {
                return this.privateKeys((List<String>)ImmutableList.of((Object)trimmed.get()));
            }
            return this.privateKeys((List<String>)ImmutableList.of());
        }

        public Builder privateKeys(List<String> privateKeys) {
            this.privateKeys = privateKeys;
            return this;
        }

        private void override() {
            if (this.env.isPresent()) {
                this.username((String)SpringUtils.getString((EnvironmentService)this.env.get(), USERNAME_KEY, this.username).orNull());
                this.requestPseudoTerminal(((EnvironmentService)this.env.get()).getBoolean(REQUEST_PSEUDO_TERMINAL_KEY, this.requestPseudoTerminal));
                this.privateKeys(SpringUtils.getStrings((EnvironmentService)this.env.get(), PRIVATE_KEYS_KEY, this.privateKeys));
                this.echo(((EnvironmentService)this.env.get()).getBoolean(ECHO_KEY, this.echo));
                this.port(((EnvironmentService)this.env.get()).getInteger(PORT_KEY, this.port));
                this.encoding(((EnvironmentService)this.env.get()).getString(ENCODING_KEY, this.encoding));
                Optional<Integer> connectTimeout = SpringUtils.getProperty(this.env, CONNECT_TIMEOUT_KEY, Integer.class, this.connectTimeout);
                if (connectTimeout.isPresent()) {
                    this.connectTimeout((Integer)connectTimeout.get());
                }
            }
        }

        private void finish() {
            this.override();
            this.privateKeys(EncUtils.decrypt(this.enc, this.privateKeys));
            this.privateKeyFiles = ImmutableList.copyOf(this.getUniquePrivateKeyFiles(this.privateKeyFiles, this.useConfigFile, this.config, this.includeDefaultPrivateKeyLocations));
            this.privateKeys = ImmutableList.copyOf(this.privateKeys);
            this.options = ImmutableProperties.copyOf(this.getSessionProperties(this.options, this.strictHostKeyChecking));
        }

        private void validate(ChannelContext ctx) {
            Assert.noBlanks(ctx.getHostname(), ctx.getEncoding());
            Assert.noNulls(ctx.getUsername(), ctx.getConnectTimeout(), ctx.getOptions(), ctx.getKnownHosts(), ctx.getConfig(), ctx.getPrivateKeyFiles(), ctx.getPrivateKeys());
            Assert.isPort(ctx.getPort());
            Assert.positive(ctx.getWaitForClosedSleepMillis());
            Assert.notEncrypted(ctx.getPrivateKeys());
            if (ctx.isUseConfigFile()) {
                Assert.exists(ctx.getConfig());
                Assert.isTrue((boolean)ctx.getConfig().canRead(), (String)("[" + ctx.getConfig() + "] exists but is not readable"));
            }
            if (ctx.getConnectTimeout().isPresent()) {
                Assert.positive((Integer)ctx.getConnectTimeout().get());
            }
        }

        public ChannelContext build() {
            this.finish();
            ChannelContext ctx = new ChannelContext(this);
            this.validate(ctx);
            return ctx;
        }

        private List<File> getUniquePrivateKeyFiles(List<File> privateKeyFiles, boolean useConfigFile, File config, boolean includeDefaultPrivateKeyLocations) {
            ArrayList<String> paths = new ArrayList<String>();
            for (File privateKeyFile : privateKeyFiles) {
                paths.add(LocationUtils.getCanonicalPath(privateKeyFile));
            }
            if (useConfigFile) {
                for (String path : SSHUtils.getFilenames(config)) {
                    paths.add(path);
                }
            }
            if (includeDefaultPrivateKeyLocations) {
                for (String path : SSHUtils.PRIVATE_KEY_DEFAULTS) {
                    paths.add(path);
                }
            }
            List<String> uniquePaths = CollectionUtils.getUniqueStrings(paths);
            return SSHUtils.getExistingAndReadable(uniquePaths);
        }

        private Properties getSessionProperties(Properties options, boolean strictHostKeyChecking) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)options);
            if (!strictHostKeyChecking) {
                properties.setProperty("StrictHostKeyChecking", "no");
            }
            return properties;
        }
    }
}

