/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.config.service;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.config.ProjectConfigContainer;
import org.kuali.common.util.config.service.AbstractCachingConfigService;
import org.kuali.common.util.project.KualiUtilProjectConstants;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.xml.service.XmlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Deprecated
public class SpringConfigService
extends AbstractCachingConfigService {
    private static final Logger logger = LoggerFactory.getLogger(SpringConfigService.class);
    private static final Map<String, ProjectConfigContainer> CACHE = new HashMap<String, ProjectConfigContainer>();
    private static final String FILE = "metadata-spring.xml";
    private static final String PROPS = "spring.properties";
    private static final String BEAN = "projectConfig";

    public SpringConfigService(ProjectService projectService, XmlService xmlService) {
        super(projectService, xmlService);
    }

    @Override
    protected synchronized ProjectConfigContainer getCachedConfig(String groupId, String artifactId) {
        String cacheKey = groupId + ":" + artifactId;
        ProjectConfigContainer config = CACHE.get(cacheKey);
        if (config == null) {
            config = this.loadMetadata(groupId, artifactId);
            logger.debug("Caching [{}]", (Object)cacheKey);
            CACHE.put(cacheKey, config);
        }
        return config;
    }

    @Override
    protected synchronized void clearCache() {
        CACHE.clear();
    }

    @Override
    protected String getFilename() {
        return FILE;
    }

    @Override
    protected Properties getBaseFilterProperties() {
        ProjectIdentifier identifier = KualiUtilProjectConstants.PROJECT_ID;
        Project project = this.getProjectService().getProject(identifier);
        String location = this.getMetadataConfigFilePath(project, PROPS);
        String encoding = ProjectUtils.getEncoding(project);
        return PropertyUtils.load(location, encoding);
    }

    @Override
    protected ProjectConfigContainer getProjectConfig(String content, String encoding) {
        GenericXmlApplicationContext context = null;
        try {
            ByteArrayResource resource = new ByteArrayResource(content.getBytes(encoding));
            context = new GenericXmlApplicationContext();
            context.load(new Resource[]{resource});
            ProjectConfigContainer projectConfigContainer = (ProjectConfigContainer)context.getBean(BEAN);
            return projectConfigContainer;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

