/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.enc;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.enc.EncUtils;
import org.kuali.common.util.enc.EncryptionService;

public final class DefaultEncryptionService
implements EncryptionService {
    private final TextEncryptor encryptor;

    public DefaultEncryptionService(TextEncryptor encryptor) {
        Assert.noNulls(encryptor);
        this.encryptor = encryptor;
    }

    @Override
    public String encrypt(String text) {
        if (EncUtils.isEncrypted(text)) {
            return text;
        }
        Assert.notEncrypted(text);
        String encryptedText = this.encryptor.encrypt(text);
        return EncUtils.wrap(encryptedText);
    }

    @Override
    public String decrypt(String text) {
        if (!EncUtils.isEncrypted(text)) {
            return text;
        }
        Assert.encrypted(text);
        String unwrapped = EncUtils.unwrap(text);
        return this.encryptor.decrypt(unwrapped);
    }

    @Override
    public void decrypt(Properties properties) {
        List<String> keys = PropertyUtils.getEncryptedKeys(properties);
        for (String key : keys) {
            String encrypted = properties.getProperty(key);
            String decrypted = this.decrypt(encrypted);
            properties.setProperty(key, decrypted);
        }
    }

    @Override
    public void encrypt(Properties properties) {
        TreeSet allKeys = Sets.newTreeSet(properties.stringPropertyNames());
        TreeSet encKeys = Sets.newTreeSet(PropertyUtils.getEncryptedKeys(properties));
        TreeSet keys = Sets.newTreeSet((Iterable)Sets.difference((Set)allKeys, (Set)encKeys));
        for (String key : keys) {
            String plaintext = properties.getProperty(key);
            String encrypted = this.encrypt(plaintext);
            properties.setProperty(key, encrypted);
        }
    }

    public TextEncryptor getEncryptor() {
        return this.encryptor;
    }
}

