/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log;

import org.kuali.common.util.Assert;
import org.kuali.common.util.log.LoggerLevel;

public final class LogMsg {
    public static final LoggerLevel DEFAULT_LOGGER_LEVEL = LoggerLevel.INFO;
    public static final String NO_MSG = "NONE";
    public static final Object[] NO_ARGS = new Object[0];
    public static final LogMsg NOOP = new LogMsg("NONE", NO_ARGS);
    private final LoggerLevel level;
    private final String message;
    private final Object[] args;

    public LogMsg(String message, Object[] args) {
        this(message, args, DEFAULT_LOGGER_LEVEL);
    }

    public LogMsg(String message) {
        this(message, NO_ARGS, DEFAULT_LOGGER_LEVEL);
    }

    public LogMsg(String message, Object[] args, LoggerLevel level) {
        Assert.noBlanks(message);
        Assert.noNulls(new Object[]{args, level});
        this.message = message;
        this.args = args;
        this.level = level;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

