/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.util.log.LoggerLevel;
import org.slf4j.Logger;

public final class LoggerContext {
    private final LoggerLevel level;
    private final String msg;
    private final ImmutableList<Object> args;
    private final Logger logger;

    private LoggerContext(Builder builder) {
        this.logger = builder.logger;
        this.level = builder.level;
        this.msg = builder.msg;
        this.args = ImmutableList.copyOf((Collection)builder.args);
    }

    public static Builder builder(Logger logger, String msg) {
        return new Builder(logger, msg);
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public String getMsg() {
        return this.msg;
    }

    public ImmutableList<Object> getArgs() {
        return this.args;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static class Builder {
        private Logger logger;
        private final String msg;
        private LoggerLevel level = LoggerLevel.INFO;
        private List<Object> args = ImmutableList.of();

        public Builder(Logger logger, String msg) {
            this.logger = logger;
            this.msg = msg;
        }

        public Builder level(LoggerLevel level) {
            this.level = level;
            return this;
        }

        public Builder args(List<Object> args) {
            this.args = args;
            return this;
        }

        public LoggerContext build() {
            LoggerContext instance = new LoggerContext(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(LoggerContext instance) {
            Preconditions.checkNotNull((Object)instance.logger, (Object)"logger cannot be null");
            Preconditions.checkNotNull((Object)((Object)instance.level), (Object)"level cannot be null");
            Preconditions.checkNotNull((Object)instance.msg, (Object)"msg cannot be null");
            Preconditions.checkNotNull((Object)instance.args, (Object)"args cannot be null");
        }
    }
}

