/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.KeyValue;
import org.kuali.common.util.StringFilter;
import org.kuali.common.util.log.LogMsg;
import org.kuali.common.util.log.LogTableContext;
import org.kuali.common.util.log.LoggerLevel;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.obscure.DefaultObscurer;
import org.kuali.common.util.obscure.Obscurer;
import org.kuali.common.util.property.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class LoggerUtils {
    public static final Logger LOGGER_UTILS_LOGGER = LoggerFactory.getLogger(LoggerUtils.class);
    private static final Obscurer DEFAULT_OBSCURER = new DefaultObscurer();
    private static final PropertyPlaceholderHelper HELPER = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;

    public static Logger make() {
        Throwable throwable = new Throwable();
        StackTraceElement[] elements = throwable.getStackTrace();
        StackTraceElement directCaller = elements[1];
        return LoggerFactory.getLogger((String)directCaller.getClassName());
    }

    public static String getLogMsg(List<String> includes, List<String> excludes) {
        if (CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes)) {
            return "";
        }
        String includesCSV = StringUtils.trimToNull((String)CollectionUtils.getSpaceSeparatedCSV(includes));
        String excludesCSV = StringUtils.trimToNull((String)CollectionUtils.getSpaceSeparatedCSV(excludes));
        ArrayList<KeyValue> msgs = new ArrayList<KeyValue>();
        if (!StringUtils.isBlank((CharSequence)includesCSV)) {
            msgs.add(new KeyValue("includes", includesCSV));
        }
        if (!StringUtils.isBlank((CharSequence)excludesCSV)) {
            msgs.add(new KeyValue("excludes", excludesCSV));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < msgs.size(); ++i) {
            if (i != 0) {
                sb.append("  ");
            }
            KeyValue msg = (KeyValue)msgs.get(i);
            sb.append(msg.getKey());
            sb.append(": ");
            sb.append(msg.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    @Deprecated
    public static String getLogMsg(StringFilter filter) {
        Assert.notNull((Object)filter, (String)"filter is null");
        return LoggerUtils.getLogMsg(filter.getIncludes(), filter.getExcludes());
    }

    @Deprecated
    public static Object[] getLogMsgArgs(StringFilter filter) {
        Assert.notNull((Object)filter, (String)"filter is null");
        String includes = CollectionUtils.getSpaceSeparatedCSV(filter.getIncludes());
        String excludes = CollectionUtils.getSpaceSeparatedCSV(filter.getExcludes());
        return new Object[]{includes, excludes};
    }

    public static void log(LogMsg msg, Logger logger) {
        Assert.notNull((Object)logger, (String)"logger is null");
        LoggerUtils.logMsg(msg.getMessage(), msg.getArgs(), logger, msg.getLevel());
    }

    public static int[] getPadding(List<String> columns, List<Object[]> argsList) {
        int[] padding = new int[columns.size()];
        for (int i = 0; i < padding.length; ++i) {
            padding[i] = Math.max(padding[i], columns.get(i).length());
        }
        for (Object[] args : argsList) {
            Assert.isTrue((columns.size() == args.length ? 1 : 0) != 0, (String)"Column count must equals args.length");
            for (int i = 0; i < args.length; ++i) {
                padding[i] = Math.max(padding[i], args[i].toString().length());
            }
        }
        return padding;
    }

    public static String getHeader(List<String> columns, int[] padding, boolean leftAlign) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i == 0) {
                sb.append("||  ");
            } else {
                sb.append("|  ");
            }
            if (leftAlign) {
                sb.append(StringUtils.rightPad((String)columns.get(i), (int)padding[i]));
            } else {
                sb.append(StringUtils.leftPad((String)columns.get(i), (int)padding[i]));
            }
            if (i == columns.size() - 1) {
                sb.append("  ||");
                continue;
            }
            sb.append("  |");
        }
        return sb.toString();
    }

    public static void updateArgsList(List<Object[]> argsList, int[] padding, boolean leftAlign) {
        for (Object[] args : argsList) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = leftAlign ? StringUtils.rightPad((String)args[i].toString(), (int)padding[i]) : StringUtils.leftPad((String)args[i].toString(), (int)padding[i]);
            }
        }
    }

    public static void logTable(List<String> columns, List<Object[]> rows, Logger logger) {
        LoggerUtils.logTable(columns, rows, LogTableContext.DEFAULT_LOGGER_LEVEL, logger, false);
    }

    public static void logTable(List<String> columns, List<Object[]> rows, LoggerLevel level, Logger logger) {
        LoggerUtils.logTable(columns, rows, level, logger, false);
    }

    public static void logTable(List<String> columns, List<Object[]> rows, LoggerLevel level, Logger logger, boolean leftAlign) {
        LogTableContext context = new LogTableContext(columns, rows, level, logger, leftAlign);
        LoggerUtils.logTable(context);
    }

    public static void logTable(String title, List<String> columns, List<Object[]> rows) {
        LogTableContext context = new LogTableContext(title, columns, rows);
        LoggerUtils.logTable(context);
    }

    public static void logTable(List<String> columns, List<Object[]> rows) {
        LogTableContext context = new LogTableContext(columns, rows);
        LoggerUtils.logTable(context);
    }

    public static String getTable(LogTableContext context) {
        Assert.notNull((Object)context, (String)"context is null");
        int[] padding = LoggerUtils.getPadding(context.getColumns(), context.getRows());
        int cols = context.getColumns().size();
        int rows = context.getRows().size();
        String header = LoggerUtils.getHeader(context.getColumns(), padding, context.isLeftAlign());
        LoggerUtils.updateArgsList(context.getRows(), padding, context.isLeftAlign());
        Properties properties = LoggerUtils.getProperties(context.getRows());
        String tableString = LoggerUtils.getTableString(rows, cols);
        String resolved = HELPER.replacePlaceholders(tableString, properties);
        return header + "\n" + resolved;
    }

    public static void logTable(LogTableContext context) {
        String table = LoggerUtils.getTable(context);
        int cols = context.getColumns().size();
        int rows = context.getRows().size();
        String defaultTitle = "Displaying a table with " + cols + " columns and " + rows + " rows\n\n";
        String title = StringUtils.equals((CharSequence)"NONE", (CharSequence)context.getTitle()) ? defaultTitle : context.getTitle() + "\n\n";
        String msg = title + table;
        LoggerUtils.logMsg(msg, context.getLogger(), context.getLevel());
    }

    protected static String getTableString(int rows, int cols) {
        StringBuilder sb = new StringBuilder();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                sb.append("${" + LoggerUtils.getPropertyKey(row, col) + "}");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected static Properties getProperties(List<Object[]> rows) {
        Properties properties = new Properties();
        for (int row = 0; row < rows.size(); ++row) {
            Object[] rowData = rows.get(row);
            for (int col = 0; col < rowData.length; ++col) {
                String key = LoggerUtils.getPropertyKey(row, col);
                StringBuilder sb = new StringBuilder();
                if (col == 0) {
                    sb.append("||  ");
                } else {
                    sb.append("|  ");
                }
                sb.append(rowData[col] + "");
                if (col == rowData.length - 1) {
                    sb.append("  ||");
                } else {
                    sb.append("  |");
                }
                properties.setProperty(key, sb.toString());
            }
        }
        return properties;
    }

    protected static String getPropertyKey(int row, int col) {
        return "log.table.row." + row + ".col." + col;
    }

    public static void logLines(String s, Logger logger, LoggerLevel level) {
        String[] lines;
        if (s == null) {
            return;
        }
        for (String line : lines = StringUtils.split((String)s, (String)"\n")) {
            LoggerUtils.logMsg(line, logger, level);
        }
    }

    public static final void logMsg(String msg, Object[] args, Logger logger, LoggerLevel level) {
        if (StringUtils.equals((CharSequence)"NONE", (CharSequence)msg)) {
            return;
        }
        switch (level) {
            case DEBUG: {
                logger.debug(msg, args);
                return;
            }
            case TRACE: {
                logger.trace(msg, args);
                return;
            }
            case INFO: {
                logger.info(msg, args);
                return;
            }
            case WARN: {
                logger.warn(msg, args);
                return;
            }
            case ERROR: {
                logger.error(msg, args);
                return;
            }
        }
        throw new IllegalArgumentException("Logger level " + (Object)((Object)level) + " is unknown");
    }

    public static final void logMsg(String msg, Logger logger, LoggerLevel level) {
        LoggerUtils.logMsg(msg, null, logger, level);
    }

    public static final String getUsername(String username) {
        return LoggerUtils.getNullAsNone(username);
    }

    public static final String getNullAsNone(String string) {
        if (string == null) {
            return "NONE";
        }
        return string;
    }

    public static final String getPassword(String username, String password) {
        return LoggerUtils.getPassword(username, password, DEFAULT_OBSCURER);
    }

    public static boolean isNullOrNone(String s) {
        return NullUtils.isNullOrNone(s);
    }

    public static final String getPassword(String username, String password, Obscurer obscurer) {
        if (LoggerUtils.isNullOrNone(password)) {
            return "NONE";
        }
        if (StringUtils.equals((CharSequence)username, (CharSequence)password)) {
            return password;
        }
        return obscurer.obscure(password);
    }
}

