/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log.log4j;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Encodings;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.log.log4j.Log4JService;
import org.kuali.common.util.log.log4j.model.Log4JConfiguration;
import org.kuali.common.util.xml.service.XmlService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class DefaultLog4JService
implements Log4JService {
    private static final String ENCODING = Encodings.UTF8;
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private static final String UNSUPPORTED_LOCATION_TYPE = "Only .properties and .xml locations are supported";
    private final XmlService service;

    public DefaultLog4JService(XmlService service) {
        Assert.noNulls(service);
        this.service = service;
    }

    @Override
    public void configure(Log4JConfiguration config) {
        String xml = this.toXml(config);
        Document document = this.getDocument(xml);
        this.configure(document);
    }

    @Override
    public void reset() {
        LogManager.resetConfiguration();
    }

    @Override
    public void configure(String location) {
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)("[" + location + "] does not exist"));
        boolean properties = StringUtils.endsWithIgnoreCase((CharSequence)location, (CharSequence)PROPERTIES_SUFFIX);
        boolean xml = StringUtils.endsWithIgnoreCase((CharSequence)location, (CharSequence)XML_SUFFIX);
        Assert.isTrue((properties || xml ? 1 : 0) != 0, (String)UNSUPPORTED_LOCATION_TYPE);
        if (properties) {
            this.configure(PropertyUtils.load(location, ENCODING));
        } else if (xml) {
            this.configureFromXmlLocation(location);
        } else {
            throw new IllegalArgumentException(UNSUPPORTED_LOCATION_TYPE);
        }
    }

    @Override
    public String toXml(Log4JConfiguration config) {
        return this.service.toXml(config, ENCODING);
    }

    @Override
    public void configure(Element element) {
        DOMConfigurator.configure((Element)element);
    }

    @Override
    public void configure(Properties properties) {
        PropertyConfigurator.configure((Properties)properties);
    }

    @Override
    public void write(File file, Log4JConfiguration config) {
        FileOutputStream out = null;
        try {
            String xml = this.toXml(config);
            out = FileUtils.openOutputStream((File)file);
            IOUtils.write((String)xml, (OutputStream)out, (String)ENCODING);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unexpected IO error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    protected void configure(Document document) {
        DOMConfigurator.configure((Element)document.getDocumentElement());
    }

    protected void configureFromXmlLocation(String location) {
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            Document document = this.getDocument(in);
            this.configure(document);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected Document getDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        return parser.parse(in);
    }

    protected Document getDocument(String xml) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(ENCODING));
            return this.getDocument(in);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public XmlService getXmlService() {
        return this.service;
    }
}

