/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.log.log4j.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.log.log4j.model.AppenderRef;
import org.kuali.common.util.log.log4j.model.Level;
import org.kuali.common.util.log.log4j.model.Threshold;
import org.kuali.common.util.xml.jaxb.adapter.OmitNoneStringAdapter;
import org.kuali.common.util.xml.jaxb.adapter.OmitTrueAdapter;

public class Logger {
    public static final List<Logger> EMPTY = Collections.emptyList();
    public static final boolean DEFAULT_ADDITIVITY = true;
    public static final Logger DEFAULT = new Logger();
    @XmlAttribute
    @XmlJavaTypeAdapter(value=OmitNoneStringAdapter.class)
    private final String name;
    @XmlElement(name="appender-ref")
    private final List<AppenderRef> references;
    @XmlElement
    private final Level level;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=OmitTrueAdapter.class)
    private final Boolean additivity;

    private Logger() {
        this("NONE", AppenderRef.EMPTY, Level.DEFAULT);
    }

    public Logger(String name, Level level) {
        this(name, AppenderRef.EMPTY, level, true);
    }

    public Logger(String name, List<AppenderRef> references) {
        this(name, references, Level.DEFAULT, true);
    }

    public Logger(String name, List<AppenderRef> references, Level level) {
        this(name, references, level, true);
    }

    public Logger(String name, List<AppenderRef> references, Level level, boolean additivity) {
        Assert.noBlanks(name);
        Assert.noNulls(references, level);
        this.name = name;
        this.references = new ArrayList<AppenderRef>(references);
        this.level = level;
        this.additivity = additivity;
    }

    public List<AppenderRef> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public boolean getAdditivity() {
        return this.additivity;
    }

    public String getName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    public static boolean isThresholdNull(Logger logger) {
        return Threshold.NULL.equals((Object)logger.getLevel().getValue());
    }

    public static Logger getRootLogger(AppenderRef reference, Level level) {
        return Logger.getRootLogger(CollectionUtils.singletonList(reference), level);
    }

    public static Logger getRootLogger(List<AppenderRef> references, Level level) {
        return new Logger("NONE", references, level);
    }
}

