/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.main;

import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.main.MainContext;

public final class ValidatePropertiesLocationExecutable
implements Executable {
    private final String message;
    private final MainContext context;

    public ValidatePropertiesLocationExecutable(MainContext context, String message) {
        Assert.noNulls(context);
        Assert.noBlanks(message);
        this.context = context;
        this.message = message;
    }

    @Override
    public void execute() {
        String[] args = this.context.getArgs();
        Assert.notNull((Object)args, (String)this.message);
        Assert.isTrue((args.length > 0 ? 1 : 0) != 0, (String)this.message);
        String location = args[0];
        Assert.noBlanks(this.message, location);
        LocationUtils.validateLocation(location, this.message);
    }

    public String getMessage() {
        return this.message;
    }

    public MainContext getContext() {
        return this.context;
    }
}

