/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.metainf.model.PathComparator;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.springframework.util.CollectionUtils;

public class ConfigurablePathComparator
extends PathComparator {
    private List<String> qualifierOrder = Collections.emptyList();
    private List<MetaInfDataLocation> locationOrder = Collections.emptyList();
    private List<MetaInfDataType> typeOrder = Collections.emptyList();

    @Override
    protected int compare(int index, String[] tokens1, String[] tokens2) {
        int compare;
        int compare2;
        String string1 = tokens1[index];
        String string2 = tokens2[index];
        if (!CollectionUtils.isEmpty(this.qualifierOrder) && this.qualifierOrder.contains(string1) && this.qualifierOrder.contains(string2) && (compare2 = Ordering.explicit(this.qualifierOrder).compare((Object)string1, (Object)string2)) != 0) {
            return compare2;
        }
        if (!CollectionUtils.isEmpty(this.locationOrder) && this.isLocation(string1) && this.isLocation(string2)) {
            MetaInfDataLocation location1 = MetaInfDataLocation.valueOf(StringUtils.upperCase((String)string1));
            MetaInfDataLocation location2 = MetaInfDataLocation.valueOf(StringUtils.upperCase((String)string2));
            compare = Ordering.explicit(this.locationOrder).compare((Object)location1, (Object)location2);
            if (compare != 0) {
                return compare;
            }
        }
        if (!CollectionUtils.isEmpty(this.typeOrder) && this.isType(string1) && this.isType(string2)) {
            MetaInfDataType type1 = MetaInfDataType.valueOf(StringUtils.upperCase((String)string1));
            MetaInfDataType type2 = MetaInfDataType.valueOf(StringUtils.upperCase((String)string2));
            compare = Ordering.explicit(this.typeOrder).compare((Object)type1, (Object)type2);
            if (compare != 0) {
                return compare;
            }
        }
        return super.compare(index, tokens1, tokens2);
    }

    protected boolean isLocation(String token) {
        return EnumUtils.isValidEnum(MetaInfDataLocation.class, (String)StringUtils.upperCase((String)token));
    }

    protected boolean isType(String token) {
        return EnumUtils.isValidEnum(MetaInfDataType.class, (String)StringUtils.upperCase((String)token));
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConfigurablePathComparator(Builder builder) {
        this.qualifierOrder = builder.qualifierOrder;
        this.locationOrder = builder.locationOrder;
        this.typeOrder = builder.typeOrder;
    }

    public static class Builder {
        private List<String> qualifierOrder = Collections.emptyList();
        private List<MetaInfDataLocation> locationOrder = Collections.emptyList();
        private List<MetaInfDataType> typeOrder = Collections.emptyList();

        public Builder qualifierOrder(List<String> qualifierOrder) {
            this.qualifierOrder = qualifierOrder;
            return this;
        }

        public Builder locationOrder(List<MetaInfDataLocation> locationOrder) {
            this.locationOrder = locationOrder;
            return this;
        }

        public Builder typeOrder(List<MetaInfDataType> typeOrder) {
            this.typeOrder = typeOrder;
            return this;
        }

        public ConfigurablePathComparator build() {
            this.qualifierOrder = ImmutableList.copyOf(this.qualifierOrder);
            this.locationOrder = ImmutableList.copyOf(this.locationOrder);
            this.typeOrder = ImmutableList.copyOf(this.typeOrder);
            return new ConfigurablePathComparator(this);
        }
    }
}

