/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.model;

import com.google.common.base.Preconditions;
import java.util.Comparator;

public class PathComparator
implements Comparator<String> {
    @Override
    public int compare(String path1, String path2) {
        Preconditions.checkNotNull((Object)path1, (Object)"'path1' cannot be null");
        Preconditions.checkNotNull((Object)path2, (Object)"'path2' cannot be null");
        String[] tokens1 = this.getPathTokens(path1);
        String[] tokens2 = this.getPathTokens(path2);
        return this.compare(tokens1, tokens2);
    }

    @Override
    protected int compare(String[] tokens1, String[] tokens2) {
        for (int i = 0; i < tokens1.length && i < tokens2.length; ++i) {
            int compare = this.compare(i, tokens1, tokens2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    protected int compare(int index, String[] tokens1, String[] tokens2) {
        if (this.isLastToken(index, tokens1) && !this.isLastToken(index, tokens2)) {
            return -1;
        }
        if (!this.isLastToken(index, tokens1) && this.isLastToken(index, tokens2)) {
            return 1;
        }
        return tokens1[index].compareTo(tokens2[index]);
    }

    protected String[] getPathTokens(String s) {
        return s.replace('\\', '/').split("/");
    }

    protected boolean isLastToken(int index, String[] tokens) {
        return index == tokens.length - 1;
    }
}

