/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project;

import java.nio.charset.Charset;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.cache.Cache;
import org.kuali.common.util.cache.SimpleCache;
import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.model.ImmutableProject;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.springframework.util.PropertyPlaceholderHelper;

public class DefaultProjectService
implements ProjectService {
    private static final Cache<String, Project> CACHE = new SimpleCache<String, Project>();
    private static final PropertyPlaceholderHelper PPH = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;
    private static final String PROPERTIES_ENCODING_KEY = "project.properties.encoding";
    private static final String PROPERTIES_ENCODING_DEFAULT = Charset.defaultCharset().toString();
    private final EnvironmentService env;

    public DefaultProjectService(EnvironmentService env) {
        Assert.noNulls(env);
        this.env = env;
    }

    @Override
    @Deprecated
    public Project getProject(Properties properties) {
        String groupId = properties.getProperty("project.groupId");
        String artifactId = properties.getProperty("project.artifactId");
        String version = properties.getProperty("project.version");
        return new ImmutableProject(groupId, artifactId, version, properties);
    }

    @Override
    public Project getProject(ProjectIdentifier identifier) {
        return this.getProject(identifier.getGroupId(), identifier.getArtifactId());
    }

    @Override
    public Project getProject(String groupId, String artifactId) {
        Assert.noBlanks("groupId and artifactId are required", groupId, artifactId);
        String cacheKey = groupId + ":" + artifactId;
        Project project = CACHE.get(cacheKey);
        if (project == null) {
            project = this.load(groupId, artifactId);
            CACHE.put(cacheKey, project);
        }
        return project;
    }

    protected void clearCache() {
        CACHE.clear();
    }

    protected Project load(String groupId, String artifactId) {
        String location = this.getPropertiesFileLocation(groupId, artifactId);
        Assert.exists(location, "[" + location + "] does not exist");
        String encoding = this.env.getString(PROPERTIES_ENCODING_KEY, PROPERTIES_ENCODING_DEFAULT);
        Properties properties = PropertyUtils.load(location, encoding);
        return this.getProject(properties);
    }

    protected String getPropertiesFileLocation(String groupId, String artifactId) {
        Properties properties = new Properties();
        properties.setProperty("project.groupId.path", Str.getPath(groupId));
        properties.setProperty("project.artifactId", artifactId);
        return PPH.replacePlaceholders("classpath:META-INF/${project.groupId.path}/${project.artifactId}/project.properties", properties);
    }

    public EnvironmentService getEnv() {
        return this.env;
    }
}

