/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.file.DirRequest;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.scm.ScmConfig;
import org.kuali.common.util.scm.UpdateScmExecutable;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={ScmConfig.class})
public class ScmProjectConfig {
    private static final String PROJECTS_KEY = "scm.build.projects";
    private static final String RELATIVE_DIR_KEY = "scm.dir.relative";
    private static final String SOURCE_DIR_KEY = "scm.dir.src";
    private static final String INCLUDES_KEY = "scm.includes";
    private static final String EXCLUDES_KEY = "scm.excludes";
    private static final String SKIP_KEY = "scm.skip";
    private static final String COMMIT_SKIP_KEY = "scm.commit.skip";
    private static final String COMMIT_PATHS_KEY = "scm.commit.paths";
    private static final String COMMIT_MESSAGE_KEY = "scm.commit.message";
    @Autowired
    Environment env;
    @Autowired
    ScmConfig scmConfig;

    @Bean
    public Executable projectScmConfigUpdateScmExecutable() {
        boolean skip = SpringUtils.getBoolean(this.env, SKIP_KEY, false);
        boolean skipCommit = SpringUtils.getBoolean(this.env, COMMIT_SKIP_KEY, true);
        List<File> commitPaths = SpringUtils.getFilesFromCSV(this.env, COMMIT_PATHS_KEY, "NONE");
        String commitMessage = SpringUtils.getProperty(this.env, COMMIT_MESSAGE_KEY);
        UpdateScmExecutable exec = new UpdateScmExecutable();
        exec.setRequests(this.projectScmConfigDirRequests());
        exec.setScmService(this.scmConfig.scmService());
        exec.setSkip(skip);
        exec.setSkipCommit(skipCommit);
        exec.setCommitPaths(commitPaths);
        exec.setMessage(commitMessage);
        return exec;
    }

    @Bean
    public List<DirRequest> projectScmConfigDirRequests() {
        List<String> projectIds = SpringUtils.getNoneSensitiveListFromCSV(this.env, PROJECTS_KEY);
        List<String> includes = SpringUtils.getNoneSensitiveListFromCSV(this.env, INCLUDES_KEY);
        List<String> excludes = SpringUtils.getNoneSensitiveListFromCSV(this.env, EXCLUDES_KEY);
        List<ProjectIdentifier> identifiers = ProjectUtils.getIdentifiers(projectIds);
        File stagingDir = SpringUtils.getFile(this.env, SOURCE_DIR_KEY);
        File relativeDir = SpringUtils.getFile(this.env, RELATIVE_DIR_KEY);
        ArrayList<DirRequest> requests = new ArrayList<DirRequest>();
        for (ProjectIdentifier identifier : identifiers) {
            DirRequest request = this.getDirRequest(identifier, stagingDir, relativeDir, includes, excludes);
            requests.add(request);
        }
        return requests;
    }

    protected DirRequest getDirRequest(ProjectIdentifier identifier, File stagingDir, File relativeDir, List<String> includes, List<String> excludes) {
        String key = "scm.build." + identifier.getArtifactId() + ".dir";
        File projectResourceDir = SpringUtils.getFile(this.env, key);
        File targetDir = ProjectUtils.getResourceDirectory(projectResourceDir, identifier.getGroupId(), identifier.getArtifactId());
        File sourceDir = ProjectUtils.getResourceDirectory(stagingDir, identifier.getGroupId(), identifier.getArtifactId());
        DirRequest request = new DirRequest();
        request.setRelativeDir(relativeDir);
        request.setTargetDir(targetDir);
        request.setSourceDir(sourceDir);
        request.setIncludes(includes);
        request.setExcludes(excludes);
        return request;
    }
}

