/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PrintlnStreamConsumer;
import org.kuali.common.util.service.DefaultExecContext;
import org.kuali.common.util.service.DefaultExecService;
import org.kuali.common.util.service.MySqlDumpContext;
import org.kuali.common.util.service.MySqlDumpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMySqlDumpService
extends DefaultExecService
implements MySqlDumpService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMySqlDumpService.class);

    @Override
    public void dump(String username, String password, String hostname, String database, File outputFile) {
        MySqlDumpContext context = new MySqlDumpContext();
        context.setExecutable("mysqldump");
        context.setUsername(username);
        context.setPassword(password);
        context.setHostname(hostname);
        context.setDatabase(database);
        context.setOutputFile(outputFile);
        this.dump(context);
    }

    @Override
    public void dump(List<String> options, String database, File outputFile) {
        MySqlDumpContext context = new MySqlDumpContext();
        context.setExecutable("mysqldump");
        context.setOptions(options);
        context.setDatabase(database);
        context.setOutputFile(outputFile);
        this.dump(context);
    }

    @Override
    public void dump(MySqlDumpContext context) {
        Assert.notNull((Object)context.getDatabase(), (String)"database is null");
        Assert.notNull((Object)context.getOutputFile(), (String)"output file is null");
        Assert.notNull((Object)context.getExecutable(), (String)"executable is null");
        this.fillInOptions(context);
        DefaultExecContext dec = this.getExecContext(context);
        this.beforeDump(context);
        this.dump(dec, context);
    }

    protected void beforeDump(MySqlDumpContext context) {
        String username = StringUtils.trimToEmpty((String)context.getUsername());
        String hostname = StringUtils.trimToEmpty((String)context.getHostname());
        int port = context.getPort();
        String database = context.getDatabase();
        String path = LocationUtils.getCanonicalPath(context.getOutputFile());
        Object[] args = new Object[]{username, hostname, port, database, path};
        logger.info("Dumping [{}@{}:{}/{}] -> [{}]", args);
    }

    protected void dump(DefaultExecContext context, MySqlDumpContext msdc) {
        PrintStream out = null;
        try {
            out = LocationUtils.openPrintStream(msdc.getOutputFile());
            PrintlnStreamConsumer standardOutConsumer = new PrintlnStreamConsumer(out, msdc.getIgnorers());
            context.setStandardOutConsumer(standardOutConsumer);
            long start = System.currentTimeMillis();
            int result = this.execute(context);
            long elapsed = System.currentTimeMillis() - start;
            if (result != 0) {
                throw new IllegalStateException("Non-zero exit value - " + result);
            }
            this.afterDump(msdc, elapsed, standardOutConsumer.getLineCount(), standardOutConsumer.getSkipCount());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    protected void afterDump(MySqlDumpContext context, long elapsed, long lineCount, long skippedCount) {
        long length = context.getOutputFile().length();
        String time = FormatUtils.getTime(elapsed);
        String size = FormatUtils.getSize(length);
        String rate = FormatUtils.getRate(elapsed, length);
        String lines = FormatUtils.getCount(lineCount);
        String skipped = FormatUtils.getCount(skippedCount);
        Object[] args = new Object[]{time, size, rate, lines, skipped};
        logger.info("Dump completed. [Time:{}, Size:{}, Rate:{}, Lines:{}  Skipped:{}]", args);
    }

    protected DefaultExecContext getExecContext(MySqlDumpContext context) {
        List<String> args = this.getArgs(context);
        DefaultExecContext dec = new DefaultExecContext();
        dec.setExecutable(context.getExecutable());
        dec.setArgs(args);
        return dec;
    }

    protected List<String> getArgs(MySqlDumpContext context) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(CollectionUtils.toEmptyList(context.getOptions()));
        args.add(context.getDatabase());
        args.addAll(CollectionUtils.toEmptyList(context.getTables()));
        return args;
    }

    protected void fillInOptions(MySqlDumpContext context) {
        List<Object> options = context.getOptions() == null ? new ArrayList() : context.getOptions();
        options.add(0, "--port=" + context.getPort());
        if (!StringUtils.isBlank((CharSequence)context.getHostname())) {
            options.add(0, "--host=" + context.getHostname());
        }
        if (!StringUtils.isBlank((CharSequence)context.getPassword())) {
            options.add(0, "--password=" + context.getPassword());
        }
        if (!StringUtils.isBlank((CharSequence)context.getUsername())) {
            options.add(0, "--user=" + context.getUsername());
        }
        context.setOptions(options);
    }
}

