/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.PropertiesContext;
import org.springframework.beans.factory.FactoryBean;

public class PropertiesLoaderFactoryBean
extends PropertiesContext
implements FactoryBean<Properties> {
    protected Properties global = PropertyUtils.getGlobalProperties();
    boolean singleton = true;

    public Properties getObject() throws Exception {
        Assert.notNull((Object)this.helper, (String)"helper is null");
        Assert.notNull((Object)this.locations, (String)"locations are null");
        Assert.notNull((Object)this.encoding, (String)"encoding is null");
        Assert.notNull((Object)((Object)this.missingLocationsMode), (String)"missingLocationsMode is null");
        Properties global = PropertyUtils.getGlobalProperties();
        this.properties = PropertyUtils.toEmpty(this.properties);
        Properties result = new Properties();
        for (String location : this.locations) {
            Properties resolverProperties = PropertyUtils.combine(this.properties, result, global);
            String resolvedLocation = this.helper.replacePlaceholders(location, resolverProperties);
            if (LocationUtils.exists(resolvedLocation)) {
                Properties properties = PropertyUtils.load(location, this.encoding);
                result.putAll((Map<?, ?>)properties);
                continue;
            }
            ModeUtils.validate(this.missingLocationsMode, "Skipping non-existent location [" + resolvedLocation + "]");
        }
        return result;
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }
}

