/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env;

import java.io.File;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.spring.env.EnvContext;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.env.model.EnvironmentServiceContext;

public final class BasicEnvironmentService
implements EnvironmentService {
    private final EnvironmentServiceContext context;

    public BasicEnvironmentService() {
        this(new EnvironmentServiceContext.Builder().build());
    }

    public BasicEnvironmentService(Properties properties) {
        this(new EnvironmentServiceContext.Builder().env(properties).build());
    }

    public BasicEnvironmentService(EnvironmentServiceContext context) {
        Assert.noNulls(context);
        this.context = context;
    }

    @Override
    public boolean containsProperty(String key) {
        Assert.noBlanks(key);
        return this.context.getEnv().containsProperty(key);
    }

    @Override
    public <T> T getProperty(EnvContext<T> context) {
        T returnValue;
        Assert.noNulls(context);
        T springValue = this.getSpringValue(context.getKey(), context.getType());
        T t = returnValue = springValue == null ? context.getDefaultValue() : springValue;
        if (returnValue == null) {
            ModeUtils.validate(this.context.getMissingPropertyMode(), this.getMissingPropertyMessage(context.getKey()));
        }
        return returnValue;
    }

    @Override
    public <T> T getProperty(String key, Class<T> type, T provided) {
        return this.getProperty(EnvContext.newCtx(key, type, provided));
    }

    @Override
    public <T> T getProperty(String key, Class<T> type) {
        return this.getProperty(EnvContext.newCtx(key, type, null));
    }

    protected String getMissingPropertyMessage(String key) {
        if (this.context.isCheckEnvironmentVariables()) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return "No value for [" + key + "] or [" + envKey + "]";
        }
        return "No value for [" + key + "]";
    }

    protected <T> T getSpringValue(String key, Class<T> type) {
        Object value = this.context.getEnv().getProperty(key, type);
        if (value == null && this.context.isCheckEnvironmentVariables()) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return (T)this.context.getEnv().getProperty(envKey, type);
        }
        return (T)value;
    }

    protected <T> Class<T> getSpringValueAsClass(String key, Class<T> type) {
        Class value = this.context.getEnv().getPropertyAsClass(key, type);
        if (value == null && this.context.isCheckEnvironmentVariables()) {
            String envKey = EnvUtils.getEnvironmentVariableKey(key);
            return this.context.getEnv().getPropertyAsClass(envKey, type);
        }
        return value;
    }

    @Override
    public <T> Class<T> getClass(String key, Class<T> type) {
        return this.getClass(key, type, null);
    }

    @Override
    public <T> Class<T> getClass(String key, Class<T> type, Class<T> defaultValue) {
        Class<T> returnValue;
        Class<T> springValue = this.getSpringValueAsClass(key, type);
        Class<T> clazz = returnValue = springValue == null ? defaultValue : springValue;
        if (returnValue == null) {
            ModeUtils.validate(this.context.getMissingPropertyMode(), this.getMissingPropertyMessage(key));
        }
        return returnValue;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String string = this.getProperty(EnvContext.newString(key, defaultValue));
        if (this.context.isResolveStrings()) {
            return this.context.getEnv().resolveRequiredPlaceholders(string);
        }
        return string;
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getProperty(EnvContext.newBoolean(key, defaultValue));
    }

    @Override
    public File getFile(String key) {
        return this.getFile(key, null);
    }

    @Override
    public File getFile(String key, File defaultValue) {
        return this.getProperty(EnvContext.newFile(key, defaultValue));
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getProperty(EnvContext.newInteger(key, defaultValue));
    }

    @Override
    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public EnvironmentServiceContext getContext() {
        return this.context;
    }
}

