/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.ssh.impl;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Encodings;
import org.kuali.common.util.ssh.api.SshService;
import org.kuali.common.util.ssh.model.Algorithm;
import org.kuali.common.util.ssh.model.GenerateKeyPairContext;
import org.kuali.common.util.ssh.model.KeyPair;

public class DefaultSshService
implements SshService {
    private static final String UTF8 = Encodings.UTF8;
    private static final int DSA = 1;
    private static final int RSA = 2;

    @Override
    public org.kuali.common.util.ssh.model.KeyPair generateKeyPair(GenerateKeyPairContext context) {
        Assert.noNulls(context);
        int algorithm = Algorithm.DSA == context.getAlgorithm() ? 1 : 2;
        JSch jsch = new JSch();
        KeyPair keyPair = this.getKeyPair(jsch, algorithm, context.getSize());
        String publicKey = this.getPublicKey(keyPair, context.getName()).trim();
        String privateKey = this.getPrivateKey(keyPair);
        String fingerprint = keyPair.getFingerPrint();
        return new KeyPair.Builder(context.getName()).publicKey(publicKey).privateKey(privateKey).fingerprint(fingerprint).build();
    }

    protected KeyPair getKeyPair(JSch jsch, int type, int size) {
        try {
            return KeyPair.genKeyPair((JSch)jsch, (int)type, (int)size);
        }
        catch (JSchException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getPrivateKey(KeyPair keyPair) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        keyPair.writePrivateKey((OutputStream)out);
        return this.toUTF8String(out);
    }

    protected String getPublicKey(KeyPair keyPair, String name) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        keyPair.writePublicKey((OutputStream)out, name);
        return this.toUTF8String(out);
    }

    protected String toUTF8String(ByteArrayOutputStream out) {
        try {
            return out.toString(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

