/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.wait;

import org.kuali.common.util.Assert;

public final class WaitResult {
    private final long start;
    private final long stop;
    private final long elapsed;

    private WaitResult(Builder builder) {
        this.start = builder.start;
        this.stop = builder.stop;
        this.elapsed = builder.elapsed;
    }

    public long getStart() {
        return this.start;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public long getStop() {
        return this.stop;
    }

    public static class Builder {
        private final long start;
        private final long stop;
        private final long elapsed;

        public Builder(long start, long stop) {
            this.start = start;
            this.stop = stop;
            this.elapsed = stop - start;
        }

        public WaitResult build() {
            Assert.noNegatives(this.start, this.stop, this.elapsed);
            Assert.isTrue((this.stop >= this.start ? 1 : 0) != 0, (String)"stop is less than start");
            return new WaitResult(this);
        }
    }
}

