/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.common.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(UrlBuilder.class);

    public String getPublishUrl(MavenProject project, SiteContext context) {
        return this.getSiteUrl(project, context, context.getPublishBase());
    }

    public String getPublicUrl(MavenProject project, SiteContext context) {
        return this.getSiteUrl(project, context, context.getPublicBase());
    }

    protected boolean isTargetGroupId(MavenProject project, String groupId) {
        if (project == null || groupId == null) {
            return false;
        }
        return groupId.equals(project.getGroupId());
    }

    protected String getTrimmedGroupId(MavenProject project, String organizationGroupId) {
        String groupId = project.getGroupId();
        if (StringUtils.isEmpty((String)organizationGroupId)) {
            logger.warn("No organization group id to compare with");
            return groupId;
        }
        if (!groupId.startsWith(organizationGroupId)) {
            logger.warn("Group Id: '" + groupId + "' does not start with '" + organizationGroupId + "'");
            return groupId;
        }
        String trimmed = StringUtils.replace((String)groupId, (String)organizationGroupId, (String)"");
        if (trimmed.startsWith(".")) {
            trimmed = trimmed.substring(1);
        }
        return trimmed;
    }

    protected String getGroupIdPath(String groupId) {
        return groupId.replace(".", "/");
    }

    protected boolean isTopLevelProject(MavenProject project, List<MavenProject> orgPoms) {
        MavenProject parent = project.getParent();
        if (parent == null) {
            return true;
        }
        return this.isMatch(parent, orgPoms);
    }

    protected boolean isMatch(MavenProject project, List<MavenProject> targetProjects) {
        for (MavenProject targetProject : targetProjects) {
            if (!this.isMatch(project, targetProject)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(MavenProject project1, MavenProject project2) {
        String groupId2;
        String groupId1 = project1.getGroupId();
        if (!groupId1.equals(groupId2 = project2.getGroupId())) {
            return false;
        }
        String artifactId1 = project1.getArtifactId();
        String artifactId2 = project2.getArtifactId();
        return artifactId1.equals(artifactId2);
    }

    protected boolean isAppendArtifactId(MavenProject project, String trimmedGroupId) {
        if (this.isEmpty(project.getModules())) {
            return true;
        }
        return !trimmedGroupId.endsWith(project.getArtifactId());
    }

    protected String getSiteUrl(MavenProject project, SiteContext context, String urlBase) {
        StringBuilder sb = new StringBuilder();
        sb.append(urlBase);
        if (!context.getPublishBase().endsWith("/")) {
            sb.append("/");
        }
        sb.append(this.getSitePath(project, context.getOrgPoms(), context.getOrganizationGroupId()));
        return sb.toString();
    }

    public String getSitePath(MavenProject project, List<MavenProject> orgPoms, String orgGroupId) {
        List<String> tokens = this.getUrlTokens(project, orgPoms, orgGroupId);
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token);
            sb.append("/");
        }
        return sb.toString();
    }

    protected List<String> getUrlTokens(MavenProject project, List<MavenProject> orgPoms, String orgGroupId) {
        boolean orgPom = this.isMatch(project, orgPoms);
        if (orgPom) {
            return this.getTopLevelTokens(project, orgGroupId);
        }
        List<MavenProject> projectPath = this.getProjectPath(project);
        return this.getUrlTokens(projectPath, orgPoms, orgGroupId);
    }

    protected List<String> getUrlTokens(List<MavenProject> projects, List<MavenProject> orgPoms, String orgGroupId) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (MavenProject project : projects) {
            boolean orgPom = this.isMatch(project, orgPoms);
            if (orgPom) continue;
            this.addProjectTokens(project, orgPoms, orgGroupId, tokens);
        }
        return tokens;
    }

    protected void addProjectTokens(MavenProject project, List<MavenProject> orgPoms, String orgGroupId, List<String> tokens) {
        boolean topLevelProject = this.isTopLevelProject(project, orgPoms);
        if (topLevelProject) {
            tokens.addAll(this.getTopLevelTokens(project, orgGroupId));
        } else {
            tokens.add(project.getArtifactId());
        }
    }

    protected List<String> getTopLevelTokens(MavenProject project, String orgGroupId) {
        boolean appendArtifactId;
        ArrayList<String> tokens = new ArrayList<String>();
        String trimmedGroupId = this.getTrimmedGroupId(project, orgGroupId);
        if (trimmedGroupId.length() > 0) {
            tokens.add(this.getGroupIdPath(trimmedGroupId));
        }
        if (appendArtifactId = this.isAppendArtifactId(project, trimmedGroupId)) {
            tokens.add(project.getArtifactId());
        }
        tokens.add(project.getVersion());
        return tokens;
    }

    protected List<MavenProject> getProjectPath(MavenProject project) {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        this.buildPath(project, projects);
        Collections.reverse(projects);
        return projects;
    }

    protected void buildPath(MavenProject project, List<MavenProject> projects) {
        projects.add(project);
        MavenProject parent = project.getParent();
        if (parent == null) {
            return;
        }
        this.buildPath(parent, projects);
    }

    public String getDownloadUrl(MavenProject project, SiteContext context) {
        String baseUrl = context.getDownloadBase();
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this.getDownloadPath(project, context));
        sb.append("/");
        sb.append(this.getGroupIdPath(project.getGroupId()));
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("/");
        sb.append(project.getVersion());
        sb.append("/");
        return sb.toString();
    }

    protected String getDownloadPath(MavenProject project, SiteContext context) {
        if (this.isSnapshot(project.getVersion(), context.getSnapshotSnippet())) {
            return context.getDownloadSnapshotPath();
        }
        if (this.isOrganizationProject(project, context.getOrganizationGroupId())) {
            return context.getDownloadReleasePath();
        }
        return context.getDownloadExternalPath();
    }

    protected boolean isOrganizationProject(MavenProject project, String organizationGroupId) {
        return project.getGroupId().startsWith(organizationGroupId);
    }

    protected boolean isSnapshot(String version, String snapshotSnippet) {
        return version.toUpperCase().contains(snapshotSnippet);
    }

    protected boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public boolean containsUnresolvedProperty(String s) {
        return s.contains("${");
    }

    public boolean isUnresolved(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return true;
        }
        return this.containsUnresolvedProperty(s);
    }

    public boolean isUrlMatch(String url1, String url2) {
        if (url1.equals(url2)) {
            return true;
        }
        if ((url1 + "/").equals(url2)) {
            return true;
        }
        return url1.equals(url2 + "/");
    }

    public List<MavenProject> getMavenProjects(List<String> gavs) {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (gavs == null) {
            return projects;
        }
        for (String gav : gavs) {
            MavenProject project = this.getMavenProject(gav);
            projects.add(project);
        }
        return projects;
    }

    public MavenProject getMavenProject(String gav) {
        String[] tokens = StringUtils.splitByWholeSeparator((String)gav.trim(), (String)":");
        String groupId = null;
        String artifactId = null;
        String version = null;
        if (tokens.length > 0) {
            groupId = tokens[0].trim();
        }
        if (tokens.length > 1) {
            artifactId = tokens[1].trim();
        }
        if (tokens.length > 2) {
            version = tokens[2].trim();
        }
        MavenProject project = new MavenProject();
        project.setGroupId(groupId);
        project.setArtifactId(artifactId);
        project.setVersion(version);
        return project;
    }
}

