/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Typedef;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.kuali.maven.common.AntMavenUtils;
import org.kuali.maven.common.ResourceUtils;
import org.kuali.maven.mojo.AntTaskPojo;

public class AntMojo
extends AbstractMojo {
    ResourceUtils resourceUtils = new ResourceUtils();
    AntMavenUtils antMvnUtils = new AntMavenUtils();
    String prefix = "build.";
    String suffix = ".xml";
    public static final String DEFAULT_MAVEN_PROJECT_REFID = "maven.project";
    public static final String DEFAULT_MAVEN_PROJECT_HELPER_REFID = "maven.project.helper";
    public static final String DEFAULT_MAVEN_LOCAL_REPOSITORY_REFID = "maven.local.repository";
    public static final String DEFAULT_ANT_TARGET_NAME = "main";
    public static final String UTF_8 = "UTF-8";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    public static final String ANTLIB = "org/apache/maven/ant/tasks/antlib.xml";
    public static final String TASK_URI = "antlib:org.apache.maven.ant.tasks";
    private File workingDir;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private List<Artifact> pluginArtifacts;
    protected ArtifactRepository localRepository;
    private String propertyPrefix = "";
    private String customTaskPrefix = "";
    private boolean skip;
    private boolean exportAntProperties;
    private boolean failOnError;
    private String file;
    private String target;
    private String output;
    private String inheritAll;
    private String inheritRefs;
    private String antFilename;
    private String relativeLocalFilename;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            return;
        }
        MavenProject mavenProject = this.getMavenProject();
        try {
            File localBuildFile = this.handleAntfile();
            Project antProject = this.getAntProject(localBuildFile);
            Map pathRefs = this.antMvnUtils.getPathRefs(antProject, mavenProject, this.pluginArtifacts);
            Map<String, ?> mavenRefs = this.getMavenRefs(mavenProject);
            this.antMvnUtils.addRefs(antProject, pathRefs);
            this.antMvnUtils.addRefs(antProject, mavenRefs);
            this.antMvnUtils.setPathProperties(antProject, pathRefs);
            this.initMavenTasks(antProject);
            this.antMvnUtils.copyProperties(mavenProject, antProject, this.propertyPrefix, this.getLog(), this.localRepository);
            this.getLog().info((CharSequence)("Build File - " + this.file));
            this.getLog().info((CharSequence)("Executing target - '" + this.target + "'"));
            antProject.executeTarget(DEFAULT_ANT_TARGET_NAME);
            this.getLog().info((CharSequence)"Executed target");
            if (this.exportAntProperties) {
                this.antMvnUtils.copyProperties(antProject, mavenProject, this.getLog());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (BuildException e) {
            this.handleBuildException(e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error executing ant tasks: " + e.getMessage(), e);
        }
    }

    protected boolean isSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Ant execution");
            return true;
        }
        return false;
    }

    public Project getAntProject(File localBuildFile) throws IOException {
        Project antProject = new Project();
        File antBuildFile = this.createBuildWrapper(localBuildFile);
        ProjectHelper.configureProject((Project)antProject, (File)antBuildFile);
        antProject.init();
        BuildLogger antLogger = this.antMvnUtils.getBuildLogger(this.getLog());
        antProject.addBuildListener((BuildListener)antLogger);
        return antProject;
    }

    protected Map<String, ?> getMavenRefs(MavenProject mavenProject) {
        HashMap<String, Object> mavenRefs = new HashMap<String, Object>();
        mavenRefs.put(DEFAULT_MAVEN_PROJECT_REFID, this.getMavenProject());
        mavenRefs.put(DEFAULT_MAVEN_PROJECT_HELPER_REFID, this.projectHelper);
        mavenRefs.put(DEFAULT_MAVEN_LOCAL_REPOSITORY_REFID, this.localRepository);
        return mavenRefs;
    }

    protected void handleBuildException(BuildException e) throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("An Ant BuildException has occured: " + e.getMessage());
        String fragment = this.findFragment(e);
        if (fragment != null) {
            sb.append("\n").append(fragment);
        }
        if (!this.failOnError) {
            this.getLog().info((CharSequence)sb.toString(), (Throwable)e);
            return;
        }
        throw new MojoExecutionException(sb.toString(), (Exception)((Object)e));
    }

    public MavenProject getMavenProject() {
        return this.project;
    }

    public void initMavenTasks(Project antProject) {
        this.getLog().debug((CharSequence)"Initialize Maven Ant Tasks");
        Typedef typedef = new Typedef();
        typedef.setProject(antProject);
        typedef.setResource(ANTLIB);
        if (!this.customTaskPrefix.equals("")) {
            typedef.setURI(TASK_URI);
        }
        typedef.execute();
    }

    protected String getDefaultXML(AntTaskPojo atp) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(XML_HEADER);
        sb.append(this.getProjectOpen());
        sb.append("  <target name=\"main\">\n");
        sb.append("    " + this.getXML(atp) + "\n");
        sb.append("  </target>\n");
        sb.append("</project>\n");
        return sb.toString();
    }

    protected File createBuildWrapper(File localBuildFile) throws IOException {
        String filename = localBuildFile.getName();
        String s = StringUtils.substringBetween((String)filename, (String)(this.prefix + this.target + "."), (String)this.suffix);
        String newFilename = "wrapper." + this.target + "." + s + ".xml";
        AntTaskPojo atp = this.getAntTaskPojo();
        String xml = this.getDefaultXML(atp);
        File buildFile = new File(this.workingDir, newFilename);
        buildFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)buildFile.getAbsolutePath(), (String)UTF_8, (String)xml);
        return buildFile;
    }

    protected File handleAntfile() throws IOException {
        FileUtils.forceMkdir((File)this.workingDir);
        File localBuildFile = File.createTempFile(this.prefix + this.target + ".", this.suffix, this.workingDir);
        this.resourceUtils.copy(this.file, localBuildFile);
        this.relativeLocalFilename = this.getRelativeFilename(this.project.getBasedir(), localBuildFile);
        return localBuildFile;
    }

    protected String getRelativeFilename(File basedir, File file) {
        String s1 = basedir.getAbsolutePath();
        String s2 = file.getAbsolutePath();
        return StringUtils.replace((String)s2, (String)s1, (String)"").substring(1);
    }

    protected AntTaskPojo getAntTaskPojo() {
        AntTaskPojo pojo = new AntTaskPojo();
        pojo.setAntfile(this.relativeLocalFilename);
        pojo.setTarget(this.target);
        pojo.setOutput(this.output);
        pojo.setInheritAll(Boolean.parseBoolean(this.inheritAll));
        pojo.setInheritRefs(Boolean.parseBoolean(this.inheritRefs));
        pojo.setDir(this.project.getBasedir().getAbsolutePath());
        return pojo;
    }

    protected String getProjectOpen() {
        StringBuilder sb = new StringBuilder();
        sb.append("<project");
        sb.append(" name=\"ant-maven\"");
        sb.append(" default=\"main\"");
        sb.append(" basedir=\"" + this.project.getBasedir().getAbsolutePath() + "\"");
        if (!StringUtils.isBlank((String)this.customTaskPrefix)) {
            sb.append(" xmlns:" + this.customTaskPrefix + "=\"" + TASK_URI + "\"");
        }
        sb.append(">");
        sb.append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String findFragment(BuildException buildException) {
        if (buildException == null) return null;
        if (buildException.getLocation() == null) return null;
        if (buildException.getLocation().getFileName() == null) {
            return null;
        }
        antFile = new File(buildException.getLocation().getFileName());
        if (!antFile.exists()) {
            return null;
        }
        reader = null;
        try {
            reader = new LineNumberReader((Reader)ReaderFactory.newXmlReader((File)antFile));
            line = "";
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() != buildException.getLocation().getLineNumber()) continue;
                var5_6 = "around Ant part ..." + line.trim() + "... @ " + buildException.getLocation().getLineNumber() + ":" + buildException.getLocation().getColumnNumber() + " in " + antFile.getAbsolutePath();
                ** GOTO lbl25
            }
            ** GOTO lbl27
        }
        catch (Exception e) {
            try {
                this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                var5_7 = null;
            }
            catch (Throwable var6_8) {
                IOUtil.close(reader);
                throw var6_8;
            }
lbl25:
            // 1 sources

            IOUtil.close((Reader)reader);
            return var5_6;
lbl27:
            // 1 sources

            IOUtil.close((Reader)reader);
            return null;
            IOUtil.close((Reader)reader);
            return var5_7;
        }
    }

    protected String getXML(AntTaskPojo atp) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ant");
        sb.append(this.attr("dir", atp.getDir()));
        sb.append(this.attr("antfile", atp.getAntfile()));
        sb.append(this.attr("target", atp.getTarget()));
        sb.append(this.attr("output", atp.getOutput()));
        if (!atp.isInheritAll()) {
            sb.append(this.attr("inheritAll", atp.isInheritAll() + ""));
        }
        if (atp.isInheritRefs()) {
            sb.append(this.attr("inheritRefs", atp.isInheritRefs() + ""));
        }
        if (atp.isUseNativeBasedir()) {
            sb.append(this.attr("useNativeBaseDir", atp.isUseNativeBasedir() + ""));
        }
        sb.append(" />");
        return sb.toString();
    }

    protected String attr(String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        return " " + name + "=\"" + value + "\"";
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public String getCustomTaskPrefix() {
        return this.customTaskPrefix;
    }

    public void setCustomTaskPrefix(String customTaskPrefix) {
        this.customTaskPrefix = customTaskPrefix;
    }

    public boolean isExportAntProperties() {
        return this.exportAntProperties;
    }

    public void setExportAntProperties(boolean exportAntProperties) {
        this.exportAntProperties = exportAntProperties;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getInheritAll() {
        return this.inheritAll;
    }

    public void setInheritAll(String inheritAll) {
        this.inheritAll = inheritAll;
    }

    public String getInheritRefs() {
        return this.inheritRefs;
    }

    public void setInheritRefs(String inheritRefs) {
        this.inheritRefs = inheritRefs;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public List<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public String getAntFilename() {
        return this.antFilename;
    }

    public String getRelativeLocalFilename() {
        return this.relativeLocalFilename;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }
}

