/*
 * Decompiled with CFR 0.152.
 */
package com.dhptech.maven.stripbom;

import com.dhptech.maven.stripbom.BomMarker;
import com.dhptech.maven.stripbom.SimpleScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class StripMojo
extends AbstractMojo {
    protected static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    protected static final byte[] UTF16_BIG_ENDIAN_BOM = new byte[]{-2, -1};
    protected static final byte[] UTF16_LITTLE_ENDIAN_BOM = new byte[]{-1, -2};
    private File workingDir;
    private File directory;
    private String[] includes;
    private String[] excludes;
    private boolean useDefaultExcludes;
    private boolean strip = true;
    private boolean failBuild = true;

    public boolean isStrip() {
        return this.strip;
    }

    public void setStrip(boolean strip) {
        this.strip = strip;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public void setFailBuild(boolean failBuild) {
        this.failBuild = failBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsBom(File file, byte[] bom) throws IOException {
        boolean bl;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] bytes = new byte[bom.length];
            ((InputStream)in).read(bytes);
            bl = Arrays.equals(bytes, bom);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bl;
    }

    protected int containsBom(File file, List<byte[]> boms) throws IOException {
        for (int i = 0; i < boms.size(); ++i) {
            if (!this.containsBom(file, boms.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected List<File> getFileList() {
        SimpleScanner scanner = new SimpleScanner(this.directory, this.includes, this.excludes, this.useDefaultExcludes);
        String[] filenames = scanner.getSelectedFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        for (String filename : filenames) {
            File file = new File(filename);
            fileList.add(file);
        }
        return fileList;
    }

    protected List<byte[]> getBoms() {
        ArrayList<byte[]> boms = new ArrayList<byte[]>();
        boms.add(UTF8_BOM);
        boms.add(UTF16_LITTLE_ENDIAN_BOM);
        boms.add(UTF16_BIG_ENDIAN_BOM);
        return boms;
    }

    protected List<BomMarker> getBomMarkers(List<File> fileList, List<byte[]> boms) throws IOException {
        ArrayList<BomMarker> bomMarkers = new ArrayList<BomMarker>();
        for (File file : fileList) {
            this.getLog().debug((CharSequence)("Examining " + file.getAbsolutePath()));
            int index = this.containsBom(file, boms);
            if (index == -1) continue;
            this.logBomFound(file);
            int skipBytes = boms.get(index).length;
            BomMarker bm = new BomMarker();
            bm.setFile(file);
            bm.setSkipBytes(skipBytes);
            bomMarkers.add(bm);
        }
        return bomMarkers;
    }

    protected void logBomFound(File file) {
        if (this.failBuild) {
            this.getLog().error((CharSequence)("BOM located in " + file.getAbsolutePath()));
        } else if (this.strip) {
            this.getLog().info((CharSequence)("BOM located in " + file.getAbsolutePath()));
        } else {
            this.getLog().warn((CharSequence)("BOM located in " + file.getAbsolutePath()));
        }
    }

    public void execute() throws MojoExecutionException {
        try {
            List<byte[]> boms = this.getBoms();
            List<File> fileList = this.getFileList();
            this.getLog().info((CharSequence)("Examining " + fileList.size() + " files for BOM's"));
            List<BomMarker> bomMarkers = this.getBomMarkers(fileList, boms);
            if (bomMarkers.size() == 0) {
                this.getLog().info((CharSequence)"No BOM's detected");
            }
            if (this.strip && bomMarkers.size() > 0) {
                this.getLog().info((CharSequence)("Removing BOM's from " + bomMarkers.size() + " files"));
                this.stripBoms(bomMarkers);
            }
            if (this.failBuild && bomMarkers.size() > 0) {
                throw new MojoExecutionException(bomMarkers.size() + " BOM's were detected");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unexpected IO error", (Exception)e);
        }
    }

    protected void stripBoms(List<BomMarker> bomMarkers) throws IOException {
        FileUtils.forceMkdir((File)this.workingDir);
        int count = 1;
        for (BomMarker bomMarker : bomMarkers) {
            this.stripBom(bomMarker, count++);
        }
    }

    protected void stripBom(BomMarker bm, int count) throws IOException {
        this.getLog().info((CharSequence)(count + " --------"));
        File backup = File.createTempFile(bm.getFile().getName() + ".", ".bak", this.workingDir);
        this.getLog().info((CharSequence)("Creating " + backup.getAbsolutePath()));
        FileUtils.copyFile((File)bm.getFile(), (File)backup);
        byte[] bytes = FileUtils.readFileToByteArray((File)bm.getFile());
        int length = bytes.length - bm.getSkipBytes();
        byte[] newBytes = new byte[length];
        System.arraycopy(bytes, bm.getSkipBytes(), newBytes, 0, newBytes.length);
        this.getLog().info((CharSequence)("Rewriting " + bm.getFile().getAbsolutePath()));
        FileUtils.writeByteArrayToFile((File)bm.getFile(), (byte[])newBytes);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File basedir) {
        this.directory = basedir;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

