/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Snapshot;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;
import org.kuali.maven.ec2.WaitControl;

public class CreateSnapshotMojo
extends AbstractEC2Mojo {
    private String volumeId;
    private String description;
    private boolean wait;
    private int waitTimeout;
    private int sleep;
    private String state;

    @Override
    protected boolean isSkip() {
        if ("NONE".equals(this.volumeId)) {
            this.getLog().info((CharSequence)("volumeId=" + this.volumeId));
            return true;
        }
        return false;
    }

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        WaitControl wc = new WaitControl(this.wait, this.waitTimeout, this.state);
        wc.setSleep(this.sleep * 1000);
        long start = System.currentTimeMillis();
        Snapshot snapshot = ec2Utils.createSnapshot(this.volumeId, this.description, wc);
        long millis = System.currentTimeMillis() - start;
        this.getLog().info((CharSequence)("Elapsed: " + millis / 1000L + "s"));
        this.getLog().info((CharSequence)("Setting ec2.snapshot.id=" + snapshot.getSnapshotId()));
        this.project.getProperties().setProperty("ec2.snapshot.id", snapshot.getSnapshotId());
        ec2Utils.tag(snapshot.getSnapshotId(), this.tags);
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }
}

